/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorization;

public class DescribeEndpointAuthorizationPublisher
implements SdkPublisher<DescribeEndpointAuthorizationResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeEndpointAuthorizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointAuthorizationPublisher(RedshiftAsyncClient client, DescribeEndpointAuthorizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointAuthorizationPublisher(RedshiftAsyncClient client, DescribeEndpointAuthorizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointAuthorizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointAuthorizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EndpointAuthorization> endpointAuthorizationList() {
        Function<DescribeEndpointAuthorizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointAuthorizationList() != null) {
                return response.endpointAuthorizationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEndpointAuthorizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEndpointAuthorizationResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointAuthorizationResponse> {
        private DescribeEndpointAuthorizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointAuthorizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEndpointAuthorizationResponse> nextPage(DescribeEndpointAuthorizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointAuthorizationPublisher.this.client.describeEndpointAuthorization(DescribeEndpointAuthorizationPublisher.this.firstRequest);
            }
            return DescribeEndpointAuthorizationPublisher.this.client.describeEndpointAuthorization((DescribeEndpointAuthorizationRequest)((Object)DescribeEndpointAuthorizationPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

