/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.Mode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeConfigurationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeConfigurationOption> {
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(NodeConfigurationOption.getter(NodeConfigurationOption::nodeType)).setter(NodeConfigurationOption.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(NodeConfigurationOption.getter(NodeConfigurationOption::numberOfNodes)).setter(NodeConfigurationOption.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<Double> ESTIMATED_DISK_UTILIZATION_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EstimatedDiskUtilizationPercent").getter(NodeConfigurationOption.getter(NodeConfigurationOption::estimatedDiskUtilizationPercent)).setter(NodeConfigurationOption.setter(Builder::estimatedDiskUtilizationPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedDiskUtilizationPercent").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(NodeConfigurationOption.getter(NodeConfigurationOption::modeAsString)).setter(NodeConfigurationOption.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, ESTIMATED_DISK_UTILIZATION_PERCENT_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final Double estimatedDiskUtilizationPercent;
    private final String mode;

    private NodeConfigurationOption(BuilderImpl builder) {
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.estimatedDiskUtilizationPercent = builder.estimatedDiskUtilizationPercent;
        this.mode = builder.mode;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public final Double estimatedDiskUtilizationPercent() {
        return this.estimatedDiskUtilizationPercent;
    }

    public final Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedDiskUtilizationPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfigurationOption)) {
            return false;
        }
        NodeConfigurationOption other = (NodeConfigurationOption)obj;
        return Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.estimatedDiskUtilizationPercent(), other.estimatedDiskUtilizationPercent()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeConfigurationOption").add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("EstimatedDiskUtilizationPercent", (Object)this.estimatedDiskUtilizationPercent()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "EstimatedDiskUtilizationPercent": {
                return Optional.ofNullable(clazz.cast(this.estimatedDiskUtilizationPercent()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeConfigurationOption, T> g) {
        return obj -> g.apply((NodeConfigurationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeType;
        private Integer numberOfNodes;
        private Double estimatedDiskUtilizationPercent;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeConfigurationOption model) {
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.estimatedDiskUtilizationPercent(model.estimatedDiskUtilizationPercent);
            this.mode(model.mode);
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Double getEstimatedDiskUtilizationPercent() {
            return this.estimatedDiskUtilizationPercent;
        }

        @Override
        public final Builder estimatedDiskUtilizationPercent(Double estimatedDiskUtilizationPercent) {
            this.estimatedDiskUtilizationPercent = estimatedDiskUtilizationPercent;
            return this;
        }

        public final void setEstimatedDiskUtilizationPercent(Double estimatedDiskUtilizationPercent) {
            this.estimatedDiskUtilizationPercent = estimatedDiskUtilizationPercent;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public NodeConfigurationOption build() {
            return new NodeConfigurationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeConfigurationOption> {
        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder estimatedDiskUtilizationPercent(Double var1);

        public Builder mode(String var1);

        public Builder mode(Mode var1);
    }
}

