/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.VpcEndpoint;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointAccess> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(EndpointAccess.getter(EndpointAccess::clusterIdentifier)).setter(EndpointAccess.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(EndpointAccess.getter(EndpointAccess::resourceOwner)).setter(EndpointAccess.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupName").getter(EndpointAccess.getter(EndpointAccess::subnetGroupName)).setter(EndpointAccess.setter(Builder::subnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointStatus").getter(EndpointAccess.getter(EndpointAccess::endpointStatus)).setter(EndpointAccess.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(EndpointAccess.getter(EndpointAccess::endpointName)).setter(EndpointAccess.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<Instant> ENDPOINT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndpointCreateTime").getter(EndpointAccess.getter(EndpointAccess::endpointCreateTime)).setter(EndpointAccess.setter(Builder::endpointCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointCreateTime").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(EndpointAccess.getter(EndpointAccess::port)).setter(EndpointAccess.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(EndpointAccess.getter(EndpointAccess::address)).setter(EndpointAccess.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(EndpointAccess.getter(EndpointAccess::vpcSecurityGroups)).setter(EndpointAccess.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<VpcEndpoint> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcEndpoint").getter(EndpointAccess.getter(EndpointAccess::vpcEndpoint)).setter(EndpointAccess.setter(Builder::vpcEndpoint)).constructor(VpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, RESOURCE_OWNER_FIELD, SUBNET_GROUP_NAME_FIELD, ENDPOINT_STATUS_FIELD, ENDPOINT_NAME_FIELD, ENDPOINT_CREATE_TIME_FIELD, PORT_FIELD, ADDRESS_FIELD, VPC_SECURITY_GROUPS_FIELD, VPC_ENDPOINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterIdentifier;
    private final String resourceOwner;
    private final String subnetGroupName;
    private final String endpointStatus;
    private final String endpointName;
    private final Instant endpointCreateTime;
    private final Integer port;
    private final String address;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final VpcEndpoint vpcEndpoint;

    private EndpointAccess(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.resourceOwner = builder.resourceOwner;
        this.subnetGroupName = builder.subnetGroupName;
        this.endpointStatus = builder.endpointStatus;
        this.endpointName = builder.endpointName;
        this.endpointCreateTime = builder.endpointCreateTime;
        this.port = builder.port;
        this.address = builder.address;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.vpcEndpoint = builder.vpcEndpoint;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    public final String subnetGroupName() {
        return this.subnetGroupName;
    }

    public final String endpointStatus() {
        return this.endpointStatus;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final Instant endpointCreateTime() {
        return this.endpointCreateTime;
    }

    public final Integer port() {
        return this.port;
    }

    public final String address() {
        return this.address;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final VpcEndpoint vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAccess)) {
            return false;
        }
        EndpointAccess other = (EndpointAccess)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.resourceOwner(), other.resourceOwner()) && Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && Objects.equals(this.endpointStatus(), other.endpointStatus()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointCreateTime(), other.endpointCreateTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.address(), other.address()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.vpcEndpoint(), other.vpcEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointAccess").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ResourceOwner", (Object)this.resourceOwner()).add("SubnetGroupName", (Object)this.subnetGroupName()).add("EndpointStatus", (Object)this.endpointStatus()).add("EndpointName", (Object)this.endpointName()).add("EndpointCreateTime", (Object)this.endpointCreateTime()).add("Port", (Object)this.port()).add("Address", (Object)this.address()).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("VpcEndpoint", (Object)this.vpcEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
            case "SubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupName()));
            }
            case "EndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatus()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointCreateTime": {
                return Optional.ofNullable(clazz.cast(this.endpointCreateTime()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "VpcEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointAccess, T> g) {
        return obj -> g.apply((EndpointAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String resourceOwner;
        private String subnetGroupName;
        private String endpointStatus;
        private String endpointName;
        private Instant endpointCreateTime;
        private Integer port;
        private String address;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private VpcEndpoint vpcEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointAccess model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.resourceOwner(model.resourceOwner);
            this.subnetGroupName(model.subnetGroupName);
            this.endpointStatus(model.endpointStatus);
            this.endpointName(model.endpointName);
            this.endpointCreateTime(model.endpointCreateTime);
            this.port(model.port);
            this.address(model.address);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.vpcEndpoint(model.vpcEndpoint);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final Instant getEndpointCreateTime() {
            return this.endpointCreateTime;
        }

        @Override
        public final Builder endpointCreateTime(Instant endpointCreateTime) {
            this.endpointCreateTime = endpointCreateTime;
            return this;
        }

        public final void setEndpointCreateTime(Instant endpointCreateTime) {
            this.endpointCreateTime = endpointCreateTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return this.vpcEndpoint != null ? this.vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        public EndpointAccess build() {
            return new EndpointAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointAccess> {
        public Builder clusterIdentifier(String var1);

        public Builder resourceOwner(String var1);

        public Builder subnetGroupName(String var1);

        public Builder endpointStatus(String var1);

        public Builder endpointName(String var1);

        public Builder endpointCreateTime(Instant var1);

        public Builder port(Integer var1);

        public Builder address(String var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder vpcEndpoint(VpcEndpoint var1);

        default public Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return this.vpcEndpoint((VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation(vpcEndpoint)).build());
        }
    }
}

