/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ActionType;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeConfigurationOptionsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeNodeConfigurationOptionsRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::actionTypeAsString)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::clusterIdentifier)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::snapshotIdentifier)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::ownerAccount)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<List<NodeConfigurationOptionsFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::filters)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), ListTrait.builder().memberLocationName("NodeConfigurationOptionsFilter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeConfigurationOptionsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOptionsFilter").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::marker)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeNodeConfigurationOptionsRequest.getter(DescribeNodeConfigurationOptionsRequest::maxRecords)).setter(DescribeNodeConfigurationOptionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, OWNER_ACCOUNT_FIELD, FILTERS_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD));
    private final String actionType;
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String ownerAccount;
    private final List<NodeConfigurationOptionsFilter> filters;
    private final String marker;
    private final Integer maxRecords;

    private DescribeNodeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.ownerAccount = builder.ownerAccount;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<NodeConfigurationOptionsFilter> filters() {
        return this.filters;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeNodeConfigurationOptionsRequest other = (DescribeNodeConfigurationOptionsRequest)((Object)obj);
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeConfigurationOptionsRequest").add("ActionType", (Object)this.actionTypeAsString()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("OwnerAccount", (Object)this.ownerAccount()).add("Filters", this.hasFilters() ? this.filters() : null).add("Marker", (Object)this.marker()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String actionType;
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String ownerAccount;
        private List<NodeConfigurationOptionsFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsRequest model) {
            super(model);
            this.actionType(model.actionType);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.ownerAccount(model.ownerAccount);
            this.filters(model.filters);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final List<NodeConfigurationOptionsFilter.Builder> getFilters() {
            List<NodeConfigurationOptionsFilter.Builder> result = NodeConfigurationOptionsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<NodeConfigurationOptionsFilter> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(NodeConfigurationOptionsFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (NodeConfigurationOptionsFilter)((NodeConfigurationOptionsFilter.Builder)NodeConfigurationOptionsFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<NodeConfigurationOptionsFilter.BuilderImpl> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNodeConfigurationOptionsRequest build() {
            return new DescribeNodeConfigurationOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeConfigurationOptionsRequest> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder ownerAccount(String var1);

        public Builder filters(Collection<NodeConfigurationOptionsFilter> var1);

        public Builder filters(NodeConfigurationOptionsFilter ... var1);

        public Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder> ... var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

