/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;
import software.amazon.awssdk.services.redshift.model.EventInfoMapListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventCategoriesMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventCategoriesMap> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventCategoriesMap.getter(EventCategoriesMap::sourceType)).setter(EventCategoriesMap.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<List<EventInfoMap>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventCategoriesMap.getter(EventCategoriesMap::events)).setter(EventCategoriesMap.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName("EventInfoMap").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventInfoMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInfoMap").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final List<EventInfoMap> events;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.events = builder.events;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public List<EventInfoMap> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"EventCategoriesMap").add("SourceType", (Object)this.sourceType()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventCategoriesMap, T> g) {
        return obj -> g.apply((EventCategoriesMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<EventInfoMap> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            this.sourceType(model.sourceType);
            this.events(model.events);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<EventInfoMap.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(EventInfoMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<EventInfoMap> events) {
            this.events = EventInfoMapListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(EventInfoMap ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<EventInfoMap.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (EventInfoMap)((EventInfoMap.Builder)EventInfoMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<EventInfoMap.BuilderImpl> events) {
            this.events = EventInfoMapListCopier.copyFromBuilder(events);
        }

        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventCategoriesMap> {
        public Builder sourceType(String var1);

        public Builder events(Collection<EventInfoMap> var1);

        public Builder events(EventInfoMap ... var1);

        public Builder events(Consumer<EventInfoMap.Builder> ... var1);
    }
}

