/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.DataSetSummary;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;

public class ListDataSetsIterable
implements SdkIterable<ListDataSetsResponse> {
    private final QuickSightClient client;
    private final ListDataSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSetsIterable(QuickSightClient client, ListDataSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataSetsResponseFetcher();
    }

    public Iterator<ListDataSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSetSummary> dataSetSummaries() {
        Function<ListDataSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetSummaries() != null) {
                return response.dataSetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSetsResponseFetcher
    implements SyncPageFetcher<ListDataSetsResponse> {
        private ListDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSetsResponse nextPage(ListDataSetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetsIterable.this.client.listDataSets(ListDataSetsIterable.this.firstRequest);
            }
            return ListDataSetsIterable.this.client.listDataSets((ListDataSetsRequest)((Object)ListDataSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

