/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for a service, such as the service code and available attribute names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(Service::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(Service::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            ATTRIBUTE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final List<String> attributeNames;

    private Service(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * <p>
     * The code for the AWS service.
     * </p>
     * 
     * @return The code for the AWS service.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * Returns true if the AttributeNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that are available for this service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes that are available for this service.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && hasAttributeNames() == other.hasAttributeNames()
                && Objects.equals(attributeNames(), other.attributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("ServiceCode", serviceCode())
                .add("AttributeNames", hasAttributeNames() ? attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The code for the AWS service.
         * </p>
         * 
         * @param serviceCode
         *        The code for the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The attributes that are available for this service.
         * </p>
         * 
         * @param attributeNames
         *        The attributes that are available for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * The attributes that are available for this service.
         * </p>
         * 
         * @param attributeNames
         *        The attributes that are available for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            serviceCode(model.serviceCode);
            attributeNames(model.attributeNames);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
