/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVoicesResponse extends PollyResponse implements
        ToCopyableBuilder<DescribeVoicesResponse.Builder, DescribeVoicesResponse> {
    private static final SdkField<List<Voice>> VOICES_FIELD = SdkField
            .<List<Voice>> builder(MarshallingType.LIST)
            .memberName("Voices")
            .getter(getter(DescribeVoicesResponse::voices))
            .setter(setter(Builder::voices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Voices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Voice> builder(MarshallingType.SDK_POJO)
                                            .constructor(Voice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeVoicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VOICES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Voice> voices;

    private final String nextToken;

    private DescribeVoicesResponse(BuilderImpl builder) {
        super(builder);
        this.voices = builder.voices;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Voices property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVoices() {
        return voices != null && !(voices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of voices with their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVoices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of voices with their properties.
     */
    public final List<Voice> voices() {
        return voices;
    }

    /**
     * <p>
     * The pagination token to use in the next request to continue the listing of voices. <code>NextToken</code> is
     * returned only if the response is truncated.
     * </p>
     * 
     * @return The pagination token to use in the next request to continue the listing of voices. <code>NextToken</code>
     *         is returned only if the response is truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVoices() ? voices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesResponse)) {
            return false;
        }
        DescribeVoicesResponse other = (DescribeVoicesResponse) obj;
        return hasVoices() == other.hasVoices() && Objects.equals(voices(), other.voices())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVoicesResponse").add("Voices", hasVoices() ? voices() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Voices":
            return Optional.ofNullable(clazz.cast(voices()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVoicesResponse, T> g) {
        return obj -> g.apply((DescribeVoicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVoicesResponse> {
        /**
         * <p>
         * A list of voices with their properties.
         * </p>
         * 
         * @param voices
         *        A list of voices with their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voices(Collection<Voice> voices);

        /**
         * <p>
         * A list of voices with their properties.
         * </p>
         * 
         * @param voices
         *        A list of voices with their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voices(Voice... voices);

        /**
         * <p>
         * A list of voices with their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Voice>.Builder} avoiding the need to create
         * one manually via {@link List<Voice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Voice>.Builder#build()} is called immediately and its result
         * is passed to {@link #voices(List<Voice>)}.
         * 
         * @param voices
         *        a consumer that will call methods on {@link List<Voice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voices(List<Voice>)
         */
        Builder voices(Consumer<Voice.Builder>... voices);

        /**
         * <p>
         * The pagination token to use in the next request to continue the listing of voices. <code>NextToken</code> is
         * returned only if the response is truncated.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in the next request to continue the listing of voices.
         *        <code>NextToken</code> is returned only if the response is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PollyResponse.BuilderImpl implements Builder {
        private List<Voice> voices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesResponse model) {
            super(model);
            voices(model.voices);
            nextToken(model.nextToken);
        }

        public final List<Voice.Builder> getVoices() {
            List<Voice.Builder> result = VoiceListCopier.copyToBuilder(this.voices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder voices(Collection<Voice> voices) {
            this.voices = VoiceListCopier.copy(voices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Voice... voices) {
            voices(Arrays.asList(voices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Consumer<Voice.Builder>... voices) {
            voices(Stream.of(voices).map(c -> Voice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVoices(Collection<Voice.BuilderImpl> voices) {
            this.voices = VoiceListCopier.copyFromBuilder(voices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVoicesResponse build() {
            return new DescribeVoicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
