/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementStatistics> {
    private static final SdkField<Double> INBOX_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("InboxPercentage").getter(PlacementStatistics.getter(PlacementStatistics::inboxPercentage)).setter(PlacementStatistics.setter(Builder::inboxPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxPercentage").build()}).build();
    private static final SdkField<Double> SPAM_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SpamPercentage").getter(PlacementStatistics.getter(PlacementStatistics::spamPercentage)).setter(PlacementStatistics.setter(Builder::spamPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamPercentage").build()}).build();
    private static final SdkField<Double> MISSING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MissingPercentage").getter(PlacementStatistics.getter(PlacementStatistics::missingPercentage)).setter(PlacementStatistics.setter(Builder::missingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingPercentage").build()}).build();
    private static final SdkField<Double> SPF_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SpfPercentage").getter(PlacementStatistics.getter(PlacementStatistics::spfPercentage)).setter(PlacementStatistics.setter(Builder::spfPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpfPercentage").build()}).build();
    private static final SdkField<Double> DKIM_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DkimPercentage").getter(PlacementStatistics.getter(PlacementStatistics::dkimPercentage)).setter(PlacementStatistics.setter(Builder::dkimPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOX_PERCENTAGE_FIELD, SPAM_PERCENTAGE_FIELD, MISSING_PERCENTAGE_FIELD, SPF_PERCENTAGE_FIELD, DKIM_PERCENTAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double inboxPercentage;
    private final Double spamPercentage;
    private final Double missingPercentage;
    private final Double spfPercentage;
    private final Double dkimPercentage;

    private PlacementStatistics(BuilderImpl builder) {
        this.inboxPercentage = builder.inboxPercentage;
        this.spamPercentage = builder.spamPercentage;
        this.missingPercentage = builder.missingPercentage;
        this.spfPercentage = builder.spfPercentage;
        this.dkimPercentage = builder.dkimPercentage;
    }

    public final Double inboxPercentage() {
        return this.inboxPercentage;
    }

    public final Double spamPercentage() {
        return this.spamPercentage;
    }

    public final Double missingPercentage() {
        return this.missingPercentage;
    }

    public final Double spfPercentage() {
        return this.spfPercentage;
    }

    public final Double dkimPercentage() {
        return this.dkimPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inboxPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.spamPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.spfPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementStatistics)) {
            return false;
        }
        PlacementStatistics other = (PlacementStatistics)obj;
        return Objects.equals(this.inboxPercentage(), other.inboxPercentage()) && Objects.equals(this.spamPercentage(), other.spamPercentage()) && Objects.equals(this.missingPercentage(), other.missingPercentage()) && Objects.equals(this.spfPercentage(), other.spfPercentage()) && Objects.equals(this.dkimPercentage(), other.dkimPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementStatistics").add("InboxPercentage", (Object)this.inboxPercentage()).add("SpamPercentage", (Object)this.spamPercentage()).add("MissingPercentage", (Object)this.missingPercentage()).add("SpfPercentage", (Object)this.spfPercentage()).add("DkimPercentage", (Object)this.dkimPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboxPercentage": {
                return Optional.ofNullable(clazz.cast(this.inboxPercentage()));
            }
            case "SpamPercentage": {
                return Optional.ofNullable(clazz.cast(this.spamPercentage()));
            }
            case "MissingPercentage": {
                return Optional.ofNullable(clazz.cast(this.missingPercentage()));
            }
            case "SpfPercentage": {
                return Optional.ofNullable(clazz.cast(this.spfPercentage()));
            }
            case "DkimPercentage": {
                return Optional.ofNullable(clazz.cast(this.dkimPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementStatistics, T> g) {
        return obj -> g.apply((PlacementStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double inboxPercentage;
        private Double spamPercentage;
        private Double missingPercentage;
        private Double spfPercentage;
        private Double dkimPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementStatistics model) {
            this.inboxPercentage(model.inboxPercentage);
            this.spamPercentage(model.spamPercentage);
            this.missingPercentage(model.missingPercentage);
            this.spfPercentage(model.spfPercentage);
            this.dkimPercentage(model.dkimPercentage);
        }

        public final Double getInboxPercentage() {
            return this.inboxPercentage;
        }

        @Override
        public final Builder inboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
            return this;
        }

        public final void setInboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
        }

        public final Double getSpamPercentage() {
            return this.spamPercentage;
        }

        @Override
        public final Builder spamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
            return this;
        }

        public final void setSpamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
        }

        public final Double getMissingPercentage() {
            return this.missingPercentage;
        }

        @Override
        public final Builder missingPercentage(Double missingPercentage) {
            this.missingPercentage = missingPercentage;
            return this;
        }

        public final void setMissingPercentage(Double missingPercentage) {
            this.missingPercentage = missingPercentage;
        }

        public final Double getSpfPercentage() {
            return this.spfPercentage;
        }

        @Override
        public final Builder spfPercentage(Double spfPercentage) {
            this.spfPercentage = spfPercentage;
            return this;
        }

        public final void setSpfPercentage(Double spfPercentage) {
            this.spfPercentage = spfPercentage;
        }

        public final Double getDkimPercentage() {
            return this.dkimPercentage;
        }

        @Override
        public final Builder dkimPercentage(Double dkimPercentage) {
            this.dkimPercentage = dkimPercentage;
            return this;
        }

        public final void setDkimPercentage(Double dkimPercentage) {
            this.dkimPercentage = dkimPercentage;
        }

        public PlacementStatistics build() {
            return new PlacementStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementStatistics> {
        public Builder inboxPercentage(Double var1);

        public Builder spamPercentage(Double var1);

        public Builder missingPercentage(Double var1);

        public Builder spfPercentage(Double var1);

        public Builder dkimPercentage(Double var1);
    }
}

