/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the message template to use for the message, for each type of channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateConfiguration.Builder, TemplateConfiguration> {
    private static final SdkField<Template> EMAIL_TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("EmailTemplate").getter(getter(TemplateConfiguration::emailTemplate))
            .setter(setter(Builder::emailTemplate)).constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTemplate").build()).build();

    private static final SdkField<Template> PUSH_TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("PushTemplate").getter(getter(TemplateConfiguration::pushTemplate)).setter(setter(Builder::pushTemplate))
            .constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushTemplate").build()).build();

    private static final SdkField<Template> SMS_TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("SMSTemplate").getter(getter(TemplateConfiguration::smsTemplate)).setter(setter(Builder::smsTemplate))
            .constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSTemplate").build()).build();

    private static final SdkField<Template> VOICE_TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceTemplate").getter(getter(TemplateConfiguration::voiceTemplate))
            .setter(setter(Builder::voiceTemplate)).constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_TEMPLATE_FIELD,
            PUSH_TEMPLATE_FIELD, SMS_TEMPLATE_FIELD, VOICE_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Template emailTemplate;

    private final Template pushTemplate;

    private final Template smsTemplate;

    private final Template voiceTemplate;

    private TemplateConfiguration(BuilderImpl builder) {
        this.emailTemplate = builder.emailTemplate;
        this.pushTemplate = builder.pushTemplate;
        this.smsTemplate = builder.smsTemplate;
        this.voiceTemplate = builder.voiceTemplate;
    }

    /**
     * <p>
     * The email template to use for the message.
     * </p>
     * 
     * @return The email template to use for the message.
     */
    public final Template emailTemplate() {
        return emailTemplate;
    }

    /**
     * <p>
     * The push notification template to use for the message.
     * </p>
     * 
     * @return The push notification template to use for the message.
     */
    public final Template pushTemplate() {
        return pushTemplate;
    }

    /**
     * <p>
     * The SMS template to use for the message.
     * </p>
     * 
     * @return The SMS template to use for the message.
     */
    public final Template smsTemplate() {
        return smsTemplate;
    }

    /**
     * <p>
     * The voice template to use for the message. This object isn't supported for campaigns.
     * </p>
     * 
     * @return The voice template to use for the message. This object isn't supported for campaigns.
     */
    public final Template voiceTemplate() {
        return voiceTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(pushTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(smsTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(voiceTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration) obj;
        return Objects.equals(emailTemplate(), other.emailTemplate()) && Objects.equals(pushTemplate(), other.pushTemplate())
                && Objects.equals(smsTemplate(), other.smsTemplate()) && Objects.equals(voiceTemplate(), other.voiceTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateConfiguration").add("EmailTemplate", emailTemplate())
                .add("PushTemplate", pushTemplate()).add("SMSTemplate", smsTemplate()).add("VoiceTemplate", voiceTemplate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailTemplate":
            return Optional.ofNullable(clazz.cast(emailTemplate()));
        case "PushTemplate":
            return Optional.ofNullable(clazz.cast(pushTemplate()));
        case "SMSTemplate":
            return Optional.ofNullable(clazz.cast(smsTemplate()));
        case "VoiceTemplate":
            return Optional.ofNullable(clazz.cast(voiceTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateConfiguration, T> g) {
        return obj -> g.apply((TemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateConfiguration> {
        /**
         * <p>
         * The email template to use for the message.
         * </p>
         * 
         * @param emailTemplate
         *        The email template to use for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTemplate(Template emailTemplate);

        /**
         * <p>
         * The email template to use for the message.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #emailTemplate(Template)}.
         * 
         * @param emailTemplate
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailTemplate(Template)
         */
        default Builder emailTemplate(Consumer<Template.Builder> emailTemplate) {
            return emailTemplate(Template.builder().applyMutation(emailTemplate).build());
        }

        /**
         * <p>
         * The push notification template to use for the message.
         * </p>
         * 
         * @param pushTemplate
         *        The push notification template to use for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushTemplate(Template pushTemplate);

        /**
         * <p>
         * The push notification template to use for the message.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #pushTemplate(Template)}.
         * 
         * @param pushTemplate
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushTemplate(Template)
         */
        default Builder pushTemplate(Consumer<Template.Builder> pushTemplate) {
            return pushTemplate(Template.builder().applyMutation(pushTemplate).build());
        }

        /**
         * <p>
         * The SMS template to use for the message.
         * </p>
         * 
         * @param smsTemplate
         *        The SMS template to use for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsTemplate(Template smsTemplate);

        /**
         * <p>
         * The SMS template to use for the message.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #smsTemplate(Template)}.
         * 
         * @param smsTemplate
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsTemplate(Template)
         */
        default Builder smsTemplate(Consumer<Template.Builder> smsTemplate) {
            return smsTemplate(Template.builder().applyMutation(smsTemplate).build());
        }

        /**
         * <p>
         * The voice template to use for the message. This object isn't supported for campaigns.
         * </p>
         * 
         * @param voiceTemplate
         *        The voice template to use for the message. This object isn't supported for campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceTemplate(Template voiceTemplate);

        /**
         * <p>
         * The voice template to use for the message. This object isn't supported for campaigns.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #voiceTemplate(Template)}.
         * 
         * @param voiceTemplate
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceTemplate(Template)
         */
        default Builder voiceTemplate(Consumer<Template.Builder> voiceTemplate) {
            return voiceTemplate(Template.builder().applyMutation(voiceTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Template emailTemplate;

        private Template pushTemplate;

        private Template smsTemplate;

        private Template voiceTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateConfiguration model) {
            emailTemplate(model.emailTemplate);
            pushTemplate(model.pushTemplate);
            smsTemplate(model.smsTemplate);
            voiceTemplate(model.voiceTemplate);
        }

        public final Template.Builder getEmailTemplate() {
            return emailTemplate != null ? emailTemplate.toBuilder() : null;
        }

        @Override
        public final Builder emailTemplate(Template emailTemplate) {
            this.emailTemplate = emailTemplate;
            return this;
        }

        public final void setEmailTemplate(Template.BuilderImpl emailTemplate) {
            this.emailTemplate = emailTemplate != null ? emailTemplate.build() : null;
        }

        public final Template.Builder getPushTemplate() {
            return pushTemplate != null ? pushTemplate.toBuilder() : null;
        }

        @Override
        public final Builder pushTemplate(Template pushTemplate) {
            this.pushTemplate = pushTemplate;
            return this;
        }

        public final void setPushTemplate(Template.BuilderImpl pushTemplate) {
            this.pushTemplate = pushTemplate != null ? pushTemplate.build() : null;
        }

        public final Template.Builder getSmsTemplate() {
            return smsTemplate != null ? smsTemplate.toBuilder() : null;
        }

        @Override
        public final Builder smsTemplate(Template smsTemplate) {
            this.smsTemplate = smsTemplate;
            return this;
        }

        public final void setSmsTemplate(Template.BuilderImpl smsTemplate) {
            this.smsTemplate = smsTemplate != null ? smsTemplate.build() : null;
        }

        public final Template.Builder getVoiceTemplate() {
            return voiceTemplate != null ? voiceTemplate.toBuilder() : null;
        }

        @Override
        public final Builder voiceTemplate(Template voiceTemplate) {
            this.voiceTemplate = voiceTemplate;
            return this;
        }

        public final void setVoiceTemplate(Template.BuilderImpl voiceTemplate) {
            this.voiceTemplate = voiceTemplate != null ? voiceTemplate.build() : null;
        }

        @Override
        public TemplateConfiguration build() {
            return new TemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
