/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the schedule settings for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(Schedule::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<CampaignEventFilter> EVENT_FILTER_FIELD = SdkField
            .<CampaignEventFilter> builder(MarshallingType.SDK_POJO).memberName("EventFilter")
            .getter(getter(Schedule::eventFilter)).setter(setter(Builder::eventFilter)).constructor(CampaignEventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Frequency").getter(getter(Schedule::frequencyAsString)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<Boolean> IS_LOCAL_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLocalTime").getter(getter(Schedule::isLocalTime)).setter(setter(Builder::isLocalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLocalTime").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .memberName("QuietTime").getter(getter(Schedule::quietTime)).setter(setter(Builder::quietTime))
            .constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(Schedule::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(Schedule::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            EVENT_FILTER_FIELD, FREQUENCY_FIELD, IS_LOCAL_TIME_FIELD, QUIET_TIME_FIELD, START_TIME_FIELD, TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endTime;

    private final CampaignEventFilter eventFilter;

    private final String frequency;

    private final Boolean isLocalTime;

    private final QuietTime quietTime;

    private final String startTime;

    private final String timezone;

    private Schedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.eventFilter = builder.eventFilter;
        this.frequency = builder.frequency;
        this.isLocalTime = builder.isLocalTime;
        this.quietTime = builder.quietTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The scheduled time, in ISO 8601 format, when the campaign ended or will end.
     * </p>
     * 
     * @return The scheduled time, in ISO 8601 format, when the campaign ended or will end.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
     * </p>
     * 
     * @return The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
     */
    public final CampaignEventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * <p>
     * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
     * @see Frequency
     */
    public final Frequency frequency() {
        return Frequency.fromValue(frequency);
    }

    /**
     * <p>
     * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
     * @see Frequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base the
     * schedule on each recipient's local time, set this value to true.
     * </p>
     * 
     * @return Specifies whether the start and end times for the campaign schedule use each recipient's local time. To
     *         base the schedule on each recipient's local time, set this value to true.
     */
    public final Boolean isLocalTime() {
        return isLocalTime;
    }

    /**
     * <p>
     * The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send
     * messages to endpoints, if all the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start
     * property for the campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End
     * property for the campaign.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet
     * time is enabled.
     * </p>
     * 
     * @return The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send
     *         messages to endpoints, if all the following conditions are met:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the endpoint's time zone is later than or equal to the time specified by the
     *         QuietTime.Start property for the campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the endpoint's time zone is earlier than or equal to the time specified by the
     *         QuietTime.End property for the campaign.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even
     *         if quiet time is enabled.
     */
    public final QuietTime quietTime() {
        return quietTime;
    }

    /**
     * <p>
     * The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign
     * immediately; or, a specific time in ISO 8601 format.
     * </p>
     * 
     * @return The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the
     *         campaign immediately; or, a specific time in ISO 8601 format.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values
     * are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30,
     * UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05,
     * UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
     * </p>
     * 
     * @return The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true.
     *         Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
     *         UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12,
     *         UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isLocalTime());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(frequencyAsString(), other.frequencyAsString())
                && Objects.equals(isLocalTime(), other.isLocalTime()) && Objects.equals(quietTime(), other.quietTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("EndTime", endTime()).add("EventFilter", eventFilter())
                .add("Frequency", frequencyAsString()).add("IsLocalTime", isLocalTime()).add("QuietTime", quietTime())
                .add("StartTime", startTime()).add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "IsLocalTime":
            return Optional.ofNullable(clazz.cast(isLocalTime()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The scheduled time, in ISO 8601 format, when the campaign ended or will end.
         * </p>
         * 
         * @param endTime
         *        The scheduled time, in ISO 8601 format, when the campaign ended or will end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
         * </p>
         * 
         * @param eventFilter
         *        The type of event that causes the campaign to be sent, if the value of the Frequency property is
         *        EVENT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(CampaignEventFilter eventFilter);

        /**
         * <p>
         * The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignEventFilter.Builder} avoiding the need
         * to create one manually via {@link CampaignEventFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignEventFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #eventFilter(CampaignEventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link CampaignEventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(CampaignEventFilter)
         */
        default Builder eventFilter(Consumer<CampaignEventFilter.Builder> eventFilter) {
            return eventFilter(CampaignEventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * <p>
         * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
         * </p>
         * 
         * @param frequency
         *        Specifies how often the campaign is sent or whether the campaign is sent in response to a specific
         *        event.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
         * </p>
         * 
         * @param frequency
         *        Specifies how often the campaign is sent or whether the campaign is sent in response to a specific
         *        event.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder frequency(Frequency frequency);

        /**
         * <p>
         * Specifies whether the start and end times for the campaign schedule use each recipient's local time. To base
         * the schedule on each recipient's local time, set this value to true.
         * </p>
         * 
         * @param isLocalTime
         *        Specifies whether the start and end times for the campaign schedule use each recipient's local time.
         *        To base the schedule on each recipient's local time, set this value to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLocalTime(Boolean isLocalTime);

        /**
         * <p>
         * The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send
         * messages to endpoints, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the campaign.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if
         * quiet time is enabled.
         * </p>
         * 
         * @param quietTime
         *        The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't
         *        send messages to endpoints, if all the following conditions are met:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the endpoint's time zone is later than or equal to the time specified by the
         *        QuietTime.Start property for the campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         *        QuietTime.End property for the campaign.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign,
         *        even if quiet time is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * <p>
         * The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn't send
         * messages to endpoints, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the campaign.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if
         * quiet time is enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link QuietTime.Builder} avoiding the need to create
         * one manually via {@link QuietTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }

        /**
         * <p>
         * The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign
         * immediately; or, a specific time in ISO 8601 format.
         * </p>
         * 
         * @param startTime
         *        The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the
         *        campaign immediately; or, a specific time in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid
         * values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06,
         * UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03,
         * UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
         * </p>
         * 
         * @param timezone
         *        The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true.
         *        Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30,
         *        UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12,
         *        UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private String endTime;

        private CampaignEventFilter eventFilter;

        private String frequency;

        private Boolean isLocalTime;

        private QuietTime quietTime;

        private String startTime;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            endTime(model.endTime);
            eventFilter(model.eventFilter);
            frequency(model.frequency);
            isLocalTime(model.isLocalTime);
            quietTime(model.quietTime);
            startTime(model.startTime);
            timezone(model.timezone);
        }

        public final String getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final CampaignEventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        @Override
        public final Builder eventFilter(CampaignEventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final void setEventFilter(CampaignEventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(Frequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Boolean getIsLocalTime() {
            return isLocalTime;
        }

        @Override
        public final Builder isLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
            return this;
        }

        public final void setIsLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
