/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventFilter.Builder, EventFilter> {
    private static final SdkField<EventDimensions> DIMENSIONS_FIELD = SdkField
            .<EventDimensions> builder(MarshallingType.SDK_POJO).memberName("Dimensions").getter(getter(EventFilter::dimensions))
            .setter(setter(Builder::dimensions)).constructor(EventDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterType").getter(getter(EventFilter::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            FILTER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EventDimensions dimensions;

    private final String filterType;

    private EventFilter(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.filterType = builder.filterType;
    }

    /**
     * <p>
     * The dimensions for the event filter to use for the campaign or the journey activity.
     * </p>
     * 
     * @return The dimensions for the event filter to use for the campaign or the journey activity.
     */
    public final EventDimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are:
     * SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign
     * or performs the activity when an endpoint event (<link linkend="apps-application-id-events">Events
     * resource</link>) occurs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of event that causes the campaign to be sent or the journey activity to be performed. Valid
     *         values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and,
     *         ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link
     *         linkend="apps-application-id-events">Events resource</link>) occurs.
     * @see FilterType
     */
    public final FilterType filterType() {
        return FilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are:
     * SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign
     * or performs the activity when an endpoint event (<link linkend="apps-application-id-events">Events
     * resource</link>) occurs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of event that causes the campaign to be sent or the journey activity to be performed. Valid
     *         values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and,
     *         ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link
     *         linkend="apps-application-id-events">Events resource</link>) occurs.
     * @see FilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter) obj;
        return Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(filterTypeAsString(), other.filterTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventFilter").add("Dimensions", dimensions()).add("FilterType", filterTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "FilterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFilter> {
        /**
         * <p>
         * The dimensions for the event filter to use for the campaign or the journey activity.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the event filter to use for the campaign or the journey activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(EventDimensions dimensions);

        /**
         * <p>
         * The dimensions for the event filter to use for the campaign or the journey activity.
         * </p>
         * This is a convenience that creates an instance of the {@link EventDimensions.Builder} avoiding the need to
         * create one manually via {@link EventDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(EventDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link EventDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(EventDimensions)
         */
        default Builder dimensions(Consumer<EventDimensions.Builder> dimensions) {
            return dimensions(EventDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values
         * are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the
         * campaign or performs the activity when an endpoint event (<link linkend="apps-application-id-events">Events
         * resource</link>) occurs.
         * </p>
         * 
         * @param filterType
         *        The type of event that causes the campaign to be sent or the journey activity to be performed. Valid
         *        values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and,
         *        ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link
         *        linkend="apps-application-id-events">Events resource</link>) occurs.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values
         * are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the
         * campaign or performs the activity when an endpoint event (<link linkend="apps-application-id-events">Events
         * resource</link>) occurs.
         * </p>
         * 
         * @param filterType
         *        The type of event that causes the campaign to be sent or the journey activity to be performed. Valid
         *        values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and,
         *        ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link
         *        linkend="apps-application-id-events">Events resource</link>) occurs.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(FilterType filterType);
    }

    static final class BuilderImpl implements Builder {
        private EventDimensions dimensions;

        private String filterType;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            dimensions(model.dimensions);
            filterType(model.filterType);
        }

        public final EventDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(EventDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(EventDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getFilterType() {
            return filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
