/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for an email activity in a journey. This type of activity sends an email message to
 * participants.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMessageActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailMessageActivity.Builder, EmailMessageActivity> {
    private static final SdkField<JourneyEmailMessage> MESSAGE_CONFIG_FIELD = SdkField
            .<JourneyEmailMessage> builder(MarshallingType.SDK_POJO).memberName("MessageConfig")
            .getter(getter(EmailMessageActivity::messageConfig)).setter(setter(Builder::messageConfig))
            .constructor(JourneyEmailMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfig").build()).build();

    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextActivity").getter(getter(EmailMessageActivity::nextActivity)).setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(EmailMessageActivity::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateVersion").getter(getter(EmailMessageActivity::templateVersion))
            .setter(setter(Builder::templateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_CONFIG_FIELD,
            NEXT_ACTIVITY_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final JourneyEmailMessage messageConfig;

    private final String nextActivity;

    private final String templateName;

    private final String templateVersion;

    private EmailMessageActivity(BuilderImpl builder) {
        this.messageConfig = builder.messageConfig;
        this.nextActivity = builder.nextActivity;
        this.templateName = builder.templateName;
        this.templateVersion = builder.templateVersion;
    }

    /**
     * <p>
     * Specifies the sender address for an email message that's sent to participants in the journey.
     * </p>
     * 
     * @return Specifies the sender address for an email message that's sent to participants in the journey.
     */
    public final JourneyEmailMessage messageConfig() {
        return messageConfig;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after the message is sent.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after the message is sent.
     */
    public final String nextActivity() {
        return nextActivity;
    }

    /**
     * <p>
     * The name of the email message template to use for the message. If specified, this value must match the name of an
     * existing message template.
     * </p>
     * 
     * @return The name of the email message template to use for the message. If specified, this value must match the
     *         name of an existing message template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The unique identifier for the version of the email template to use for the message. If specified, this value must
     * match the identifier for an existing template version. To retrieve a list of versions and version identifiers for
     * a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link>
     * resource.
     * </p>
     * <p>
     * If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template.
     * The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved
     * for use, depending on your workflow. It isn't necessarily the latest version of a template.
     * </p>
     * 
     * @return The unique identifier for the version of the email template to use for the message. If specified, this
     *         value must match the identifier for an existing template version. To retrieve a list of versions and
     *         version identifiers for a template, use the <link
     *         linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
     *         <p>
     *         If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
     *         template. The <i>active version</i> is typically the version of a template that's been most recently
     *         reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a
     *         template.
     */
    public final String templateVersion() {
        return templateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessageActivity)) {
            return false;
        }
        EmailMessageActivity other = (EmailMessageActivity) obj;
        return Objects.equals(messageConfig(), other.messageConfig()) && Objects.equals(nextActivity(), other.nextActivity())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateVersion(), other.templateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailMessageActivity").add("MessageConfig", messageConfig()).add("NextActivity", nextActivity())
                .add("TemplateName", templateName()).add("TemplateVersion", templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageConfig":
            return Optional.ofNullable(clazz.cast(messageConfig()));
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateVersion":
            return Optional.ofNullable(clazz.cast(templateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailMessageActivity, T> g) {
        return obj -> g.apply((EmailMessageActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMessageActivity> {
        /**
         * <p>
         * Specifies the sender address for an email message that's sent to participants in the journey.
         * </p>
         * 
         * @param messageConfig
         *        Specifies the sender address for an email message that's sent to participants in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfig(JourneyEmailMessage messageConfig);

        /**
         * <p>
         * Specifies the sender address for an email message that's sent to participants in the journey.
         * </p>
         * This is a convenience that creates an instance of the {@link JourneyEmailMessage.Builder} avoiding the need
         * to create one manually via {@link JourneyEmailMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link JourneyEmailMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfig(JourneyEmailMessage)}.
         * 
         * @param messageConfig
         *        a consumer that will call methods on {@link JourneyEmailMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfig(JourneyEmailMessage)
         */
        default Builder messageConfig(Consumer<JourneyEmailMessage.Builder> messageConfig) {
            return messageConfig(JourneyEmailMessage.builder().applyMutation(messageConfig).build());
        }

        /**
         * <p>
         * The unique identifier for the next activity to perform, after the message is sent.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after the message is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);

        /**
         * <p>
         * The name of the email message template to use for the message. If specified, this value must match the name
         * of an existing message template.
         * </p>
         * 
         * @param templateName
         *        The name of the email message template to use for the message. If specified, this value must match the
         *        name of an existing message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The unique identifier for the version of the email template to use for the message. If specified, this value
         * must match the identifier for an existing template version. To retrieve a list of versions and version
         * identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template
         * Versions</link> resource.
         * </p>
         * <p>
         * If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
         * template. The <i>active version</i> is typically the version of a template that's been most recently reviewed
         * and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
         * </p>
         * 
         * @param templateVersion
         *        The unique identifier for the version of the email template to use for the message. If specified, this
         *        value must match the identifier for an existing template version. To retrieve a list of versions and
         *        version identifiers for a template, use the <link
         *        linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
         *        <p>
         *        If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
         *        template. The <i>active version</i> is typically the version of a template that's been most recently
         *        reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of
         *        a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersion(String templateVersion);
    }

    static final class BuilderImpl implements Builder {
        private JourneyEmailMessage messageConfig;

        private String nextActivity;

        private String templateName;

        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessageActivity model) {
            messageConfig(model.messageConfig);
            nextActivity(model.nextActivity);
            templateName(model.templateName);
            templateVersion(model.templateVersion);
        }

        public final JourneyEmailMessage.Builder getMessageConfig() {
            return messageConfig != null ? messageConfig.toBuilder() : null;
        }

        @Override
        public final Builder messageConfig(JourneyEmailMessage messageConfig) {
            this.messageConfig = messageConfig;
            return this;
        }

        public final void setMessageConfig(JourneyEmailMessage.BuilderImpl messageConfig) {
            this.messageConfig = messageConfig != null ? messageConfig.build() : null;
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateVersion() {
            return templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public EmailMessageActivity build() {
            return new EmailMessageActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
