/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an API request or response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BadRequestException extends PinpointException implements
        ToCopyableBuilder<BadRequestException.Builder, BadRequestException> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestID").getter(getter(BadRequestException::requestID)).setter(setter(Builder::requestID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String requestID;

    private BadRequestException(BuilderImpl builder) {
        super(builder);
        this.requestID = builder.requestID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The unique identifier for the request or response.
     * </p>
     * 
     * @return The unique identifier for the request or response.
     */
    public String requestID() {
        return requestID;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestException, T> g) {
        return obj -> g.apply((BadRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BadRequestException>, PinpointException.Builder {
        /**
         * <p>
         * The unique identifier for the request or response.
         * </p>
         * 
         * @param requestID
         *        The unique identifier for the request or response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestID(String requestID);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends PinpointException.BuilderImpl implements Builder {
        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestException model) {
            super(model);
            requestID(model.requestID);
        }

        public final String getRequestID() {
            return requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BadRequestException build() {
            return new BadRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
