/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StudioComponentType {
    ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
    SHARED_FILE_SYSTEM("SHARED_FILE_SYSTEM"),
    COMPUTE_FARM("COMPUTE_FARM"),
    LICENSE_SERVICE("LICENSE_SERVICE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StudioComponentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StudioComponentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StudioComponentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StudioComponentType> knownValues() {
        return Stream.of(StudioComponentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

