/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingSessionStream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingSessionStream> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StreamingSessionStream.getter(StreamingSessionStream::createdAt)).setter(StreamingSessionStream.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(StreamingSessionStream.getter(StreamingSessionStream::createdBy)).setter(StreamingSessionStream.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(StreamingSessionStream.getter(StreamingSessionStream::expiresAt)).setter(StreamingSessionStream.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(StreamingSessionStream.getter(StreamingSessionStream::stateAsString)).setter(StreamingSessionStream.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(StreamingSessionStream.getter(StreamingSessionStream::statusCodeAsString)).setter(StreamingSessionStream.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamingSessionStream.getter(StreamingSessionStream::streamId)).setter(StreamingSessionStream.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(StreamingSessionStream.getter(StreamingSessionStream::url)).setter(StreamingSessionStream.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, EXPIRES_AT_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STREAM_ID_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant expiresAt;
    private final String state;
    private final String statusCodeValue;
    private final String streamId;
    private final String url;

    private StreamingSessionStream(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.expiresAt = builder.expiresAt;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.streamId = builder.streamId;
        this.url = builder.url;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final StreamingSessionStreamState state() {
        return StreamingSessionStreamState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StreamingSessionStreamStatusCode statusCode() {
        return StreamingSessionStreamStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingSessionStream)) {
            return false;
        }
        StreamingSessionStream other = (StreamingSessionStream)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingSessionStream").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("ExpiresAt", (Object)this.expiresAt()).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StreamId", (Object)this.streamId()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingSessionStream, T> g) {
        return obj -> g.apply((StreamingSessionStream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private Instant expiresAt;
        private String state;
        private String statusCodeValue;
        private String streamId;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingSessionStream model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.expiresAt(model.expiresAt);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.streamId(model.streamId);
            this.url(model.url);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamingSessionStreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(StreamingSessionStreamStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public StreamingSessionStream build() {
            return new StreamingSessionStream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingSessionStream> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder expiresAt(Instant var1);

        public Builder state(String var1);

        public Builder state(StreamingSessionStreamState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StreamingSessionStreamStatusCode var1);

        public Builder streamId(String var1);

        public Builder url(String var1);
    }
}

