/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamingSessionStreamRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, GetStreamingSessionStreamRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetStreamingSessionStreamRequest.getter(GetStreamingSessionStreamRequest::sessionId)).setter(GetStreamingSessionStreamRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(GetStreamingSessionStreamRequest.getter(GetStreamingSessionStreamRequest::streamId)).setter(GetStreamingSessionStreamRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("streamId").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(GetStreamingSessionStreamRequest.getter(GetStreamingSessionStreamRequest::studioId)).setter(GetStreamingSessionStreamRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, STREAM_ID_FIELD, STUDIO_ID_FIELD));
    private final String sessionId;
    private final String streamId;
    private final String studioId;

    private GetStreamingSessionStreamRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.streamId = builder.streamId;
        this.studioId = builder.studioId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingSessionStreamRequest)) {
            return false;
        }
        GetStreamingSessionStreamRequest other = (GetStreamingSessionStreamRequest)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamingSessionStreamRequest").add("SessionId", (Object)this.sessionId()).add("StreamId", (Object)this.streamId()).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingSessionStreamRequest, T> g) {
        return obj -> g.apply((GetStreamingSessionStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String sessionId;
        private String streamId;
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingSessionStreamRequest model) {
            super(model);
            this.sessionId(model.sessionId);
            this.streamId(model.streamId);
            this.studioId(model.studioId);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStreamingSessionStreamRequest build() {
            return new GetStreamingSessionStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamingSessionStreamRequest> {
        public Builder sessionId(String var1);

        public Builder streamId(String var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

