/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStudioComponentRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, DeleteStudioComponentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteStudioComponentRequest.getter(DeleteStudioComponentRequest::clientToken)).setter(DeleteStudioComponentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentId").getter(DeleteStudioComponentRequest.getter(DeleteStudioComponentRequest::studioComponentId)).setter(DeleteStudioComponentRequest.setter(Builder::studioComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioComponentId").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(DeleteStudioComponentRequest.getter(DeleteStudioComponentRequest::studioId)).setter(DeleteStudioComponentRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, STUDIO_COMPONENT_ID_FIELD, STUDIO_ID_FIELD));
    private final String clientToken;
    private final String studioComponentId;
    private final String studioId;

    private DeleteStudioComponentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.studioComponentId = builder.studioComponentId;
        this.studioId = builder.studioId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String studioComponentId() {
        return this.studioComponentId;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStudioComponentRequest)) {
            return false;
        }
        DeleteStudioComponentRequest other = (DeleteStudioComponentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.studioComponentId(), other.studioComponentId()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteStudioComponentRequest").add("ClientToken", (Object)this.clientToken()).add("StudioComponentId", (Object)this.studioComponentId()).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "studioComponentId": {
                return Optional.ofNullable(clazz.cast(this.studioComponentId()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStudioComponentRequest, T> g) {
        return obj -> g.apply((DeleteStudioComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String studioComponentId;
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStudioComponentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.studioComponentId(model.studioComponentId);
            this.studioId(model.studioId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getStudioComponentId() {
            return this.studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStudioComponentRequest build() {
            return new DeleteStudioComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteStudioComponentRequest> {
        public Builder clientToken(String var1);

        public Builder studioComponentId(String var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

