/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamingSessionsResponse extends NimbleResponse implements
        ToCopyableBuilder<ListStreamingSessionsResponse.Builder, ListStreamingSessionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamingSessionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<StreamingSession>> SESSIONS_FIELD = SdkField
            .<List<StreamingSession>> builder(MarshallingType.LIST)
            .memberName("sessions")
            .getter(getter(ListStreamingSessionsResponse::sessions))
            .setter(setter(Builder::sessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamingSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamingSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SESSIONS_FIELD));

    private final String nextToken;

    private final List<StreamingSession> sessions;

    private ListStreamingSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sessions = builder.sessions;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Sessions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSessions() {
        return sessions != null && !(sessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSessions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of streaming sessions.
     */
    public final List<StreamingSession> sessions() {
        return sessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessions() ? sessions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingSessionsResponse)) {
            return false;
        }
        ListStreamingSessionsResponse other = (ListStreamingSessionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSessions() == other.hasSessions()
                && Objects.equals(sessions(), other.sessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamingSessionsResponse").add("NextToken", nextToken())
                .add("Sessions", hasSessions() ? sessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sessions":
            return Optional.ofNullable(clazz.cast(sessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingSessionsResponse, T> g) {
        return obj -> g.apply((ListStreamingSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamingSessionsResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A collection of streaming sessions.
         * </p>
         * 
         * @param sessions
         *        A collection of streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<StreamingSession> sessions);

        /**
         * <p>
         * A collection of streaming sessions.
         * </p>
         * 
         * @param sessions
         *        A collection of streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(StreamingSession... sessions);

        /**
         * <p>
         * A collection of streaming sessions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamingSession>.Builder} avoiding the
         * need to create one manually via {@link List<StreamingSession>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamingSession>.Builder#build()} is called immediately and
         * its result is passed to {@link #sessions(List<StreamingSession>)}.
         * 
         * @param sessions
         *        a consumer that will call methods on {@link List<StreamingSession>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessions(List<StreamingSession>)
         */
        Builder sessions(Consumer<StreamingSession.Builder>... sessions);
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StreamingSession> sessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingSessionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            sessions(model.sessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<StreamingSession.Builder> getSessions() {
            List<StreamingSession.Builder> result = StreamingSessionListCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sessions(Collection<StreamingSession> sessions) {
            this.sessions = StreamingSessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(StreamingSession... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<StreamingSession.Builder>... sessions) {
            sessions(Stream.of(sessions).map(c -> StreamingSession.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSessions(Collection<StreamingSession.BuilderImpl> sessions) {
            this.sessions = StreamingSessionListCopier.copyFromBuilder(sessions);
        }

        @Override
        public ListStreamingSessionsResponse build() {
            return new ListStreamingSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
