/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.Address;
import software.amazon.awssdk.services.networkfirewall.model.AddressesCopier;
import software.amazon.awssdk.services.networkfirewall.model.PortRange;
import software.amazon.awssdk.services.networkfirewall.model.PortRangesCopier;
import software.amazon.awssdk.services.networkfirewall.model.ProtocolNumbersCopier;
import software.amazon.awssdk.services.networkfirewall.model.TCPFlagField;
import software.amazon.awssdk.services.networkfirewall.model.TCPFlagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchAttributes> {
    private static final SdkField<List<Address>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(MatchAttributes.getter(MatchAttributes::sources)).setter(MatchAttributes.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Address>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(MatchAttributes.getter(MatchAttributes::destinations)).setter(MatchAttributes.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> SOURCE_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePorts").getter(MatchAttributes.getter(MatchAttributes::sourcePorts)).setter(MatchAttributes.setter(Builder::sourcePorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> DESTINATION_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPorts").getter(MatchAttributes.getter(MatchAttributes::destinationPorts)).setter(MatchAttributes.setter(Builder::destinationPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(MatchAttributes.getter(MatchAttributes::protocols)).setter(MatchAttributes.setter(Builder::protocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TCPFlagField>> TCP_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TCPFlags").getter(MatchAttributes.getter(MatchAttributes::tcpFlags)).setter(MatchAttributes.setter(Builder::tcpFlags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TCPFlags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TCPFlagField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, DESTINATIONS_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, PROTOCOLS_FIELD, TCP_FLAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Address> sources;
    private final List<Address> destinations;
    private final List<PortRange> sourcePorts;
    private final List<PortRange> destinationPorts;
    private final List<Integer> protocols;
    private final List<TCPFlagField> tcpFlags;

    private MatchAttributes(BuilderImpl builder) {
        this.sources = builder.sources;
        this.destinations = builder.destinations;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.protocols = builder.protocols;
        this.tcpFlags = builder.tcpFlags;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<Address> sources() {
        return this.sources;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<Address> destinations() {
        return this.destinations;
    }

    public final boolean hasSourcePorts() {
        return this.sourcePorts != null && !(this.sourcePorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> sourcePorts() {
        return this.sourcePorts;
    }

    public final boolean hasDestinationPorts() {
        return this.destinationPorts != null && !(this.destinationPorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> destinationPorts() {
        return this.destinationPorts;
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<Integer> protocols() {
        return this.protocols;
    }

    public final boolean hasTcpFlags() {
        return this.tcpFlags != null && !(this.tcpFlags instanceof SdkAutoConstructList);
    }

    public final List<TCPFlagField> tcpFlags() {
        return this.tcpFlags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePorts() ? this.sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPorts() ? this.destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTcpFlags() ? this.tcpFlags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchAttributes)) {
            return false;
        }
        MatchAttributes other = (MatchAttributes)obj;
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasSourcePorts() == other.hasSourcePorts() && Objects.equals(this.sourcePorts(), other.sourcePorts()) && this.hasDestinationPorts() == other.hasDestinationPorts() && Objects.equals(this.destinationPorts(), other.destinationPorts()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocols(), other.protocols()) && this.hasTcpFlags() == other.hasTcpFlags() && Objects.equals(this.tcpFlags(), other.tcpFlags());
    }

    public final String toString() {
        return ToString.builder((String)"MatchAttributes").add("Sources", this.hasSources() ? this.sources() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("SourcePorts", this.hasSourcePorts() ? this.sourcePorts() : null).add("DestinationPorts", this.hasDestinationPorts() ? this.destinationPorts() : null).add("Protocols", this.hasProtocols() ? this.protocols() : null).add("TCPFlags", this.hasTcpFlags() ? this.tcpFlags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "SourcePorts": {
                return Optional.ofNullable(clazz.cast(this.sourcePorts()));
            }
            case "DestinationPorts": {
                return Optional.ofNullable(clazz.cast(this.destinationPorts()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocols()));
            }
            case "TCPFlags": {
                return Optional.ofNullable(clazz.cast(this.tcpFlags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchAttributes, T> g) {
        return obj -> g.apply((MatchAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Address> sources = DefaultSdkAutoConstructList.getInstance();
        private List<Address> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> sourcePorts = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> destinationPorts = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> protocols = DefaultSdkAutoConstructList.getInstance();
        private List<TCPFlagField> tcpFlags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatchAttributes model) {
            this.sources(model.sources);
            this.destinations(model.destinations);
            this.sourcePorts(model.sourcePorts);
            this.destinationPorts(model.destinationPorts);
            this.protocols(model.protocols);
            this.tcpFlags(model.tcpFlags);
        }

        public final List<Address.Builder> getSources() {
            List<Address.Builder> result = AddressesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sources(Collection<Address> sources) {
            this.sources = AddressesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Address ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Address.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (Address)((Address.Builder)Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<Address.BuilderImpl> sources) {
            this.sources = AddressesCopier.copyFromBuilder(sources);
        }

        public final List<Address.Builder> getDestinations() {
            List<Address.Builder> result = AddressesCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinations(Collection<Address> destinations) {
            this.destinations = AddressesCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Address ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Address.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (Address)((Address.Builder)Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<Address.BuilderImpl> destinations) {
            this.destinations = AddressesCopier.copyFromBuilder(destinations);
        }

        public final List<PortRange.Builder> getSourcePorts() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.sourcePorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sourcePorts(Collection<PortRange> sourcePorts) {
            this.sourcePorts = PortRangesCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(PortRange ... sourcePorts) {
            this.sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(Consumer<PortRange.Builder> ... sourcePorts) {
            this.sourcePorts(Stream.of(sourcePorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourcePorts(Collection<PortRange.BuilderImpl> sourcePorts) {
            this.sourcePorts = PortRangesCopier.copyFromBuilder(sourcePorts);
        }

        public final List<PortRange.Builder> getDestinationPorts() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.destinationPorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinationPorts(Collection<PortRange> destinationPorts) {
            this.destinationPorts = PortRangesCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(PortRange ... destinationPorts) {
            this.destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Consumer<PortRange.Builder> ... destinationPorts) {
            this.destinationPorts(Stream.of(destinationPorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationPorts(Collection<PortRange.BuilderImpl> destinationPorts) {
            this.destinationPorts = PortRangesCopier.copyFromBuilder(destinationPorts);
        }

        public final Collection<Integer> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        @Override
        public final Builder protocols(Collection<Integer> protocols) {
            this.protocols = ProtocolNumbersCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Integer ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<Integer> protocols) {
            this.protocols = ProtocolNumbersCopier.copy(protocols);
        }

        public final List<TCPFlagField.Builder> getTcpFlags() {
            List<TCPFlagField.Builder> result = TCPFlagsCopier.copyToBuilder(this.tcpFlags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tcpFlags(Collection<TCPFlagField> tcpFlags) {
            this.tcpFlags = TCPFlagsCopier.copy(tcpFlags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpFlags(TCPFlagField ... tcpFlags) {
            this.tcpFlags(Arrays.asList(tcpFlags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpFlags(Consumer<TCPFlagField.Builder> ... tcpFlags) {
            this.tcpFlags(Stream.of(tcpFlags).map(c -> (TCPFlagField)((TCPFlagField.Builder)TCPFlagField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTcpFlags(Collection<TCPFlagField.BuilderImpl> tcpFlags) {
            this.tcpFlags = TCPFlagsCopier.copyFromBuilder(tcpFlags);
        }

        public MatchAttributes build() {
            return new MatchAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchAttributes> {
        public Builder sources(Collection<Address> var1);

        public Builder sources(Address ... var1);

        public Builder sources(Consumer<Address.Builder> ... var1);

        public Builder destinations(Collection<Address> var1);

        public Builder destinations(Address ... var1);

        public Builder destinations(Consumer<Address.Builder> ... var1);

        public Builder sourcePorts(Collection<PortRange> var1);

        public Builder sourcePorts(PortRange ... var1);

        public Builder sourcePorts(Consumer<PortRange.Builder> ... var1);

        public Builder destinationPorts(Collection<PortRange> var1);

        public Builder destinationPorts(PortRange ... var1);

        public Builder destinationPorts(Consumer<PortRange.Builder> ... var1);

        public Builder protocols(Collection<Integer> var1);

        public Builder protocols(Integer ... var1);

        public Builder tcpFlags(Collection<TCPFlagField> var1);

        public Builder tcpFlags(TCPFlagField ... var1);

        public Builder tcpFlags(Consumer<TCPFlagField.Builder> ... var1);
    }
}

