/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationMapCopier;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationType;
import software.amazon.awssdk.services.networkfirewall.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogDestinationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogDestinationConfig> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogType").getter(LogDestinationConfig.getter(LogDestinationConfig::logTypeAsString)).setter(LogDestinationConfig.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDestinationType").getter(LogDestinationConfig.getter(LogDestinationConfig::logDestinationTypeAsString)).setter(LogDestinationConfig.setter(Builder::logDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").build()}).build();
    private static final SdkField<Map<String, String>> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogDestination").getter(LogDestinationConfig.getter(LogDestinationConfig::logDestination)).setter(LogDestinationConfig.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logType;
    private final String logDestinationType;
    private final Map<String, String> logDestination;

    private LogDestinationConfig(BuilderImpl builder) {
        this.logType = builder.logType;
        this.logDestinationType = builder.logDestinationType;
        this.logDestination = builder.logDestination;
    }

    public final LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public final LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(this.logDestinationType);
    }

    public final String logDestinationTypeAsString() {
        return this.logDestinationType;
    }

    public final boolean hasLogDestination() {
        return this.logDestination != null && !(this.logDestination instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> logDestination() {
        return this.logDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDestination() ? this.logDestination() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDestinationConfig)) {
            return false;
        }
        LogDestinationConfig other = (LogDestinationConfig)obj;
        return Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.logDestinationTypeAsString(), other.logDestinationTypeAsString()) && this.hasLogDestination() == other.hasLogDestination() && Objects.equals(this.logDestination(), other.logDestination());
    }

    public final String toString() {
        return ToString.builder((String)"LogDestinationConfig").add("LogType", (Object)this.logTypeAsString()).add("LogDestinationType", (Object)this.logDestinationTypeAsString()).add("LogDestination", this.hasLogDestination() ? this.logDestination() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "LogDestinationType": {
                return Optional.ofNullable(clazz.cast(this.logDestinationTypeAsString()));
            }
            case "LogDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogDestinationConfig, T> g) {
        return obj -> g.apply((LogDestinationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logType;
        private String logDestinationType;
        private Map<String, String> logDestination = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogDestinationConfig model) {
            this.logType(model.logType);
            this.logDestinationType(model.logDestinationType);
            this.logDestination(model.logDestination);
        }

        public final String getLogType() {
            return this.logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        public final Map<String, String> getLogDestination() {
            if (this.logDestination instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.logDestination;
        }

        @Override
        public final Builder logDestination(Map<String, String> logDestination) {
            this.logDestination = LogDestinationMapCopier.copy(logDestination);
            return this;
        }

        public final void setLogDestination(Map<String, String> logDestination) {
            this.logDestination = LogDestinationMapCopier.copy(logDestination);
        }

        public LogDestinationConfig build() {
            return new LogDestinationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogDestinationConfig> {
        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder logDestinationType(String var1);

        public Builder logDestinationType(LogDestinationType var1);

        public Builder logDestination(Map<String, String> var1);
    }
}

