/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends MwaaRequest implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AirflowConfigurationOptions")
            .getter(getter(UpdateEnvironmentRequest::airflowConfigurationOptions))
            .setter(setter(Builder::airflowConfigurationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AirflowVersion").getter(getter(UpdateEnvironmentRequest::airflowVersion))
            .setter(setter(Builder::airflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()).build();

    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DagS3Path").getter(getter(UpdateEnvironmentRequest::dagS3Path)).setter(setter(Builder::dagS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()).build();

    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentClass").getter(getter(UpdateEnvironmentRequest::environmentClass))
            .setter(setter(Builder::environmentClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(UpdateEnvironmentRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<LoggingConfigurationInput> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(UpdateEnvironmentRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWorkers").getter(getter(UpdateEnvironmentRequest::maxWorkers)).setter(setter(Builder::maxWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()).build();

    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWorkers").getter(getter(UpdateEnvironmentRequest::minWorkers)).setter(setter(Builder::minWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<UpdateNetworkConfigurationInput> NETWORK_CONFIGURATION_FIELD = SdkField
            .<UpdateNetworkConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(UpdateEnvironmentRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(UpdateNetworkConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3ObjectVersion").getter(getter(UpdateEnvironmentRequest::pluginsS3ObjectVersion))
            .setter(setter(Builder::pluginsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build())
            .build();

    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3Path").getter(getter(UpdateEnvironmentRequest::pluginsS3Path))
            .setter(setter(Builder::pluginsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()).build();

    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3ObjectVersion")
            .getter(getter(UpdateEnvironmentRequest::requirementsS3ObjectVersion))
            .setter(setter(Builder::requirementsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion")
                    .build()).build();

    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3Path").getter(getter(UpdateEnvironmentRequest::requirementsS3Path))
            .setter(setter(Builder::requirementsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build())
            .build();

    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBucketArn").getter(getter(UpdateEnvironmentRequest::sourceBucketArn))
            .setter(setter(Builder::sourceBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()).build();

    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverAccessMode").getter(getter(UpdateEnvironmentRequest::webserverAccessModeAsString))
            .setter(setter(Builder::webserverAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(UpdateEnvironmentRequest::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AIRFLOW_CONFIGURATION_OPTIONS_FIELD, AIRFLOW_VERSION_FIELD, DAG_S3_PATH_FIELD, ENVIRONMENT_CLASS_FIELD,
            EXECUTION_ROLE_ARN_FIELD, LOGGING_CONFIGURATION_FIELD, MAX_WORKERS_FIELD, MIN_WORKERS_FIELD, NAME_FIELD,
            NETWORK_CONFIGURATION_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD, PLUGINS_S3_PATH_FIELD,
            REQUIREMENTS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, SOURCE_BUCKET_ARN_FIELD,
            WEBSERVER_ACCESS_MODE_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD));

    private final Map<String, String> airflowConfigurationOptions;

    private final String airflowVersion;

    private final String dagS3Path;

    private final String environmentClass;

    private final String executionRoleArn;

    private final LoggingConfigurationInput loggingConfiguration;

    private final Integer maxWorkers;

    private final Integer minWorkers;

    private final String name;

    private final UpdateNetworkConfigurationInput networkConfiguration;

    private final String pluginsS3ObjectVersion;

    private final String pluginsS3Path;

    private final String requirementsS3ObjectVersion;

    private final String requirementsS3Path;

    private final String sourceBucketArn;

    private final String webserverAccessMode;

    private final String weeklyMaintenanceWindowStart;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.airflowVersion = builder.airflowVersion;
        this.dagS3Path = builder.dagS3Path;
        this.environmentClass = builder.environmentClass;
        this.executionRoleArn = builder.executionRoleArn;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.maxWorkers = builder.maxWorkers;
        this.minWorkers = builder.minWorkers;
        this.name = builder.name;
        this.networkConfiguration = builder.networkConfiguration;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
    }

    /**
     * Returns true if the AirflowConfigurationOptions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAirflowConfigurationOptions() {
        return airflowConfigurationOptions != null && !(airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Airflow Configuration Options to update of your Amazon MWAA environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAirflowConfigurationOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Airflow Configuration Options to update of your Amazon MWAA environment.
     */
    public final Map<String, String> airflowConfigurationOptions() {
        return airflowConfigurationOptions;
    }

    /**
     * <p>
     * The Airflow Version to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Airflow Version to update of your Amazon MWAA environment.
     */
    public final String airflowVersion() {
        return airflowVersion;
    }

    /**
     * <p>
     * The Dags folder S3 Path to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Dags folder S3 Path to update of your Amazon MWAA environment.
     */
    public final String dagS3Path() {
        return dagS3Path;
    }

    /**
     * <p>
     * The Environment Class to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Environment Class to update of your Amazon MWAA environment.
     */
    public final String environmentClass() {
        return environmentClass;
    }

    /**
     * <p>
     * The Executio Role ARN to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Executio Role ARN to update of your Amazon MWAA environment.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Logging Configuration to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Logging Configuration to update of your Amazon MWAA environment.
     */
    public final LoggingConfigurationInput loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The maximum number of workers to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The maximum number of workers to update of your Amazon MWAA environment.
     */
    public final Integer maxWorkers() {
        return maxWorkers;
    }

    /**
     * <p>
     * The minimum number of workers to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The minimum number of workers to update of your Amazon MWAA environment.
     */
    public final Integer minWorkers() {
        return minWorkers;
    }

    /**
     * <p>
     * The name of your Amazon MWAA environment that you wish to update.
     * </p>
     * 
     * @return The name of your Amazon MWAA environment that you wish to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Network Configuration to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Network Configuration to update of your Amazon MWAA environment.
     */
    public final UpdateNetworkConfigurationInput networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The Plugins.zip S3 Object Version to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Plugins.zip S3 Object Version to update of your Amazon MWAA environment.
     */
    public final String pluginsS3ObjectVersion() {
        return pluginsS3ObjectVersion;
    }

    /**
     * <p>
     * The Plugins.zip S3 Path to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Plugins.zip S3 Path to update of your Amazon MWAA environment.
     */
    public final String pluginsS3Path() {
        return pluginsS3Path;
    }

    /**
     * <p>
     * The Requirements.txt S3 ObjectV ersion to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Requirements.txt S3 ObjectV ersion to update of your Amazon MWAA environment.
     */
    public final String requirementsS3ObjectVersion() {
        return requirementsS3ObjectVersion;
    }

    /**
     * <p>
     * The Requirements.txt S3 Path to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Requirements.txt S3 Path to update of your Amazon MWAA environment.
     */
    public final String requirementsS3Path() {
        return requirementsS3Path;
    }

    /**
     * <p>
     * The S3 Source Bucket ARN to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The S3 Source Bucket ARN to update of your Amazon MWAA environment.
     */
    public final String sourceBucketArn() {
        return sourceBucketArn;
    }

    /**
     * <p>
     * The Webserver Access Mode to update of your Amazon MWAA environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Webserver Access Mode to update of your Amazon MWAA environment.
     * @see WebserverAccessMode
     */
    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(webserverAccessMode);
    }

    /**
     * <p>
     * The Webserver Access Mode to update of your Amazon MWAA environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Webserver Access Mode to update of your Amazon MWAA environment.
     * @see WebserverAccessMode
     */
    public final String webserverAccessModeAsString() {
        return webserverAccessMode;
    }

    /**
     * <p>
     * The Weekly Maintenance Window Start to update of your Amazon MWAA environment.
     * </p>
     * 
     * @return The Weekly Maintenance Window Start to update of your Amazon MWAA environment.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAirflowConfigurationOptions() ? airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions()
                && Objects.equals(airflowConfigurationOptions(), other.airflowConfigurationOptions())
                && Objects.equals(airflowVersion(), other.airflowVersion()) && Objects.equals(dagS3Path(), other.dagS3Path())
                && Objects.equals(environmentClass(), other.environmentClass())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(maxWorkers(), other.maxWorkers()) && Objects.equals(minWorkers(), other.minWorkers())
                && Objects.equals(name(), other.name()) && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion())
                && Objects.equals(pluginsS3Path(), other.pluginsS3Path())
                && Objects.equals(requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion())
                && Objects.equals(requirementsS3Path(), other.requirementsS3Path())
                && Objects.equals(sourceBucketArn(), other.sourceBucketArn())
                && Objects.equals(webserverAccessModeAsString(), other.webserverAccessModeAsString())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateEnvironmentRequest")
                .add("AirflowConfigurationOptions",
                        airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AirflowVersion", airflowVersion()).add("DagS3Path", dagS3Path())
                .add("EnvironmentClass", environmentClass()).add("ExecutionRoleArn", executionRoleArn())
                .add("LoggingConfiguration", loggingConfiguration()).add("MaxWorkers", maxWorkers())
                .add("MinWorkers", minWorkers()).add("Name", name()).add("NetworkConfiguration", networkConfiguration())
                .add("PluginsS3ObjectVersion", pluginsS3ObjectVersion()).add("PluginsS3Path", pluginsS3Path())
                .add("RequirementsS3ObjectVersion", requirementsS3ObjectVersion())
                .add("RequirementsS3Path", requirementsS3Path()).add("SourceBucketArn", sourceBucketArn())
                .add("WebserverAccessMode", webserverAccessModeAsString())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AirflowConfigurationOptions":
            return Optional.ofNullable(clazz.cast(airflowConfigurationOptions()));
        case "AirflowVersion":
            return Optional.ofNullable(clazz.cast(airflowVersion()));
        case "DagS3Path":
            return Optional.ofNullable(clazz.cast(dagS3Path()));
        case "EnvironmentClass":
            return Optional.ofNullable(clazz.cast(environmentClass()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "MaxWorkers":
            return Optional.ofNullable(clazz.cast(maxWorkers()));
        case "MinWorkers":
            return Optional.ofNullable(clazz.cast(minWorkers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "PluginsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(pluginsS3ObjectVersion()));
        case "PluginsS3Path":
            return Optional.ofNullable(clazz.cast(pluginsS3Path()));
        case "RequirementsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(requirementsS3ObjectVersion()));
        case "RequirementsS3Path":
            return Optional.ofNullable(clazz.cast(requirementsS3Path()));
        case "SourceBucketArn":
            return Optional.ofNullable(clazz.cast(sourceBucketArn()));
        case "WebserverAccessMode":
            return Optional.ofNullable(clazz.cast(webserverAccessModeAsString()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MwaaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The Airflow Configuration Options to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param airflowConfigurationOptions
         *        The Airflow Configuration Options to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions);

        /**
         * <p>
         * The Airflow Version to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param airflowVersion
         *        The Airflow Version to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowVersion(String airflowVersion);

        /**
         * <p>
         * The Dags folder S3 Path to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param dagS3Path
         *        The Dags folder S3 Path to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagS3Path(String dagS3Path);

        /**
         * <p>
         * The Environment Class to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param environmentClass
         *        The Environment Class to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentClass(String environmentClass);

        /**
         * <p>
         * The Executio Role ARN to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param executionRoleArn
         *        The Executio Role ARN to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Logging Configuration to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param loggingConfiguration
         *        The Logging Configuration to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration);

        /**
         * <p>
         * The Logging Configuration to update of your Amazon MWAA environment.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfigurationInput.Builder} avoiding the
         * need to create one manually via {@link LoggingConfigurationInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfigurationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #loggingConfiguration(LoggingConfigurationInput)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfigurationInput)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfigurationInput.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfigurationInput.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The maximum number of workers to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param maxWorkers
         *        The maximum number of workers to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkers(Integer maxWorkers);

        /**
         * <p>
         * The minimum number of workers to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param minWorkers
         *        The minimum number of workers to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkers(Integer minWorkers);

        /**
         * <p>
         * The name of your Amazon MWAA environment that you wish to update.
         * </p>
         * 
         * @param name
         *        The name of your Amazon MWAA environment that you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Network Configuration to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param networkConfiguration
         *        The Network Configuration to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(UpdateNetworkConfigurationInput networkConfiguration);

        /**
         * <p>
         * The Network Configuration to update of your Amazon MWAA environment.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateNetworkConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link UpdateNetworkConfigurationInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateNetworkConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #networkConfiguration(UpdateNetworkConfigurationInput)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link UpdateNetworkConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(UpdateNetworkConfigurationInput)
         */
        default Builder networkConfiguration(Consumer<UpdateNetworkConfigurationInput.Builder> networkConfiguration) {
            return networkConfiguration(UpdateNetworkConfigurationInput.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The Plugins.zip S3 Object Version to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param pluginsS3ObjectVersion
         *        The Plugins.zip S3 Object Version to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion);

        /**
         * <p>
         * The Plugins.zip S3 Path to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param pluginsS3Path
         *        The Plugins.zip S3 Path to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3Path(String pluginsS3Path);

        /**
         * <p>
         * The Requirements.txt S3 ObjectV ersion to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param requirementsS3ObjectVersion
         *        The Requirements.txt S3 ObjectV ersion to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion);

        /**
         * <p>
         * The Requirements.txt S3 Path to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param requirementsS3Path
         *        The Requirements.txt S3 Path to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3Path(String requirementsS3Path);

        /**
         * <p>
         * The S3 Source Bucket ARN to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param sourceBucketArn
         *        The S3 Source Bucket ARN to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBucketArn(String sourceBucketArn);

        /**
         * <p>
         * The Webserver Access Mode to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Webserver Access Mode to update of your Amazon MWAA environment.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(String webserverAccessMode);

        /**
         * <p>
         * The Webserver Access Mode to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Webserver Access Mode to update of your Amazon MWAA environment.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(WebserverAccessMode webserverAccessMode);

        /**
         * <p>
         * The Weekly Maintenance Window Start to update of your Amazon MWAA environment.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The Weekly Maintenance Window Start to update of your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaRequest.BuilderImpl implements Builder {
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();

        private String airflowVersion;

        private String dagS3Path;

        private String environmentClass;

        private String executionRoleArn;

        private LoggingConfigurationInput loggingConfiguration;

        private Integer maxWorkers;

        private Integer minWorkers;

        private String name;

        private UpdateNetworkConfigurationInput networkConfiguration;

        private String pluginsS3ObjectVersion;

        private String pluginsS3Path;

        private String requirementsS3ObjectVersion;

        private String requirementsS3Path;

        private String sourceBucketArn;

        private String webserverAccessMode;

        private String weeklyMaintenanceWindowStart;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            airflowConfigurationOptions(model.airflowConfigurationOptions);
            airflowVersion(model.airflowVersion);
            dagS3Path(model.dagS3Path);
            environmentClass(model.environmentClass);
            executionRoleArn(model.executionRoleArn);
            loggingConfiguration(model.loggingConfiguration);
            maxWorkers(model.maxWorkers);
            minWorkers(model.minWorkers);
            name(model.name);
            networkConfiguration(model.networkConfiguration);
            pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            pluginsS3Path(model.pluginsS3Path);
            requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            requirementsS3Path(model.requirementsS3Path);
            sourceBucketArn(model.sourceBucketArn);
            webserverAccessMode(model.webserverAccessMode);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return airflowConfigurationOptions;
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = SyntheticUpdateEnvironmentInputAirflowConfigurationOptionsCopier
                    .copy(airflowConfigurationOptions);
            return this;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = SyntheticUpdateEnvironmentInputAirflowConfigurationOptionsCopier
                    .copy(airflowConfigurationOptions);
        }

        public final String getAirflowVersion() {
            return airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        public final String getDagS3Path() {
            return dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        public final String getEnvironmentClass() {
            return environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final LoggingConfigurationInput.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final void setLoggingConfiguration(LoggingConfigurationInput.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        public final Integer getMaxWorkers() {
            return maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        public final Integer getMinWorkers() {
            return minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final UpdateNetworkConfigurationInput.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(UpdateNetworkConfigurationInput networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(UpdateNetworkConfigurationInput.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPluginsS3ObjectVersion() {
            return pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        public final String getPluginsS3Path() {
            return pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        public final String getRequirementsS3ObjectVersion() {
            return requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        public final String getRequirementsS3Path() {
            return requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        public final String getSourceBucketArn() {
            return sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        public final String getWebserverAccessMode() {
            return webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
