/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsResponse extends MwaaResponse implements
        ToCopyableBuilder<ListEnvironmentsResponse.Builder, ListEnvironmentsResponse> {
    private static final SdkField<List<String>> ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Environments")
            .getter(getter(ListEnvironmentsResponse::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> environments;

    private final String nextToken;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Environments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon MWAA Environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of Amazon MWAA Environments.
     */
    public final List<String> environments() {
        return environments;
    }

    /**
     * <p>
     * The Next Token when listing MWAA environments.
     * </p>
     * 
     * @return The Next Token when listing MWAA environments.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse) obj;
        return hasEnvironments() == other.hasEnvironments() && Objects.equals(environments(), other.environments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsResponse").add("Environments", hasEnvironments() ? environments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MwaaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsResponse> {
        /**
         * <p>
         * The list of Amazon MWAA Environments.
         * </p>
         * 
         * @param environments
         *        The list of Amazon MWAA Environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<String> environments);

        /**
         * <p>
         * The list of Amazon MWAA Environments.
         * </p>
         * 
         * @param environments
         *        The list of Amazon MWAA Environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(String... environments);

        /**
         * <p>
         * The Next Token when listing MWAA environments.
         * </p>
         * 
         * @param nextToken
         *        The Next Token when listing MWAA environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MwaaResponse.BuilderImpl implements Builder {
        private List<String> environments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            environments(model.environments);
            nextToken(model.nextToken);
        }

        public final Collection<String> getEnvironments() {
            if (environments instanceof SdkAutoConstructList) {
                return null;
            }
            return environments;
        }

        @Override
        public final Builder environments(Collection<String> environments) {
            this.environments = EnvironmentListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(String... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        public final void setEnvironments(Collection<String> environments) {
            this.environments = EnvironmentListCopier.copy(environments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
