/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseConfigurationAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseConfigurationAssociation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceArn)).setter(LicenseConfigurationAssociation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceTypeAsString)).setter(LicenseConfigurationAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceOwnerId)).setter(LicenseConfigurationAssociation.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").build()}).build();
    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AssociationTime").getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::associationTime)).setter(LicenseConfigurationAssociation.setter(Builder::associationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTime").build()}).build();
    private static final SdkField<String> AMI_ASSOCIATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiAssociationScope").getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::amiAssociationScope)).setter(LicenseConfigurationAssociation.setter(Builder::amiAssociationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiAssociationScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ID_FIELD, ASSOCIATION_TIME_FIELD, AMI_ASSOCIATION_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceType;
    private final String resourceOwnerId;
    private final Instant associationTime;
    private final String amiAssociationScope;

    private LicenseConfigurationAssociation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.associationTime = builder.associationTime;
        this.amiAssociationScope = builder.amiAssociationScope;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final Instant associationTime() {
        return this.associationTime;
    }

    public final String amiAssociationScope() {
        return this.amiAssociationScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiAssociationScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfigurationAssociation)) {
            return false;
        }
        LicenseConfigurationAssociation other = (LicenseConfigurationAssociation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.associationTime(), other.associationTime()) && Objects.equals(this.amiAssociationScope(), other.amiAssociationScope());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseConfigurationAssociation").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("AssociationTime", (Object)this.associationTime()).add("AmiAssociationScope", (Object)this.amiAssociationScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "AssociationTime": {
                return Optional.ofNullable(clazz.cast(this.associationTime()));
            }
            case "AmiAssociationScope": {
                return Optional.ofNullable(clazz.cast(this.amiAssociationScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfigurationAssociation, T> g) {
        return obj -> g.apply((LicenseConfigurationAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private String resourceOwnerId;
        private Instant associationTime;
        private String amiAssociationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfigurationAssociation model) {
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.resourceOwnerId(model.resourceOwnerId);
            this.associationTime(model.associationTime);
            this.amiAssociationScope(model.amiAssociationScope);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final Instant getAssociationTime() {
            return this.associationTime;
        }

        @Override
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        public final String getAmiAssociationScope() {
            return this.amiAssociationScope;
        }

        @Override
        public final Builder amiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
            return this;
        }

        public final void setAmiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
        }

        public LicenseConfigurationAssociation build() {
            return new LicenseConfigurationAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseConfigurationAssociation> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceOwnerId(String var1);

        public Builder associationTime(Instant var1);

        public Builder amiAssociationScope(String var1);
    }
}

