/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;

public class ListExportsIterable
implements SdkIterable<ListExportsResponse> {
    private final LexModelsV2Client client;
    private final ListExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportsIterable(LexModelsV2Client client, ListExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public Iterator<ListExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExportsResponseFetcher
    implements SyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportsResponse nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsIterable.this.client.listExports(ListExportsIterable.this.firstRequest);
            }
            return ListExportsIterable.this.client.listExports((ListExportsRequest)((Object)ListExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

