/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExportRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, UpdateExportRequest> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(UpdateExportRequest.getter(UpdateExportRequest::exportId)).setter(UpdateExportRequest.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("exportId").build()}).build();
    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePassword").getter(UpdateExportRequest.getter(UpdateExportRequest::filePassword)).setter(UpdateExportRequest.setter(Builder::filePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, FILE_PASSWORD_FIELD));
    private final String exportId;
    private final String filePassword;

    private UpdateExportRequest(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.filePassword = builder.filePassword;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final String filePassword() {
        return this.filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExportRequest)) {
            return false;
        }
        UpdateExportRequest other = (UpdateExportRequest)((Object)obj);
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.filePassword(), other.filePassword());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateExportRequest").add("ExportId", (Object)this.exportId()).add("FilePassword", (Object)(this.filePassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "filePassword": {
                return Optional.ofNullable(clazz.cast(this.filePassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateExportRequest, T> g) {
        return obj -> g.apply((UpdateExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String exportId;
        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExportRequest model) {
            super(model);
            this.exportId(model.exportId);
            this.filePassword(model.filePassword);
        }

        public final String getExportId() {
            return this.exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        public final String getFilePassword() {
            return this.filePassword;
        }

        @Override
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExportRequest build() {
            return new UpdateExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateExportRequest> {
        public Builder exportId(String var1);

        public Builder filePassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

