/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBotVersionRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, DeleteBotVersionRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DeleteBotVersionRequest.getter(DeleteBotVersionRequest::botId)).setter(DeleteBotVersionRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(DeleteBotVersionRequest.getter(DeleteBotVersionRequest::botVersion)).setter(DeleteBotVersionRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipResourceInUseCheck").getter(DeleteBotVersionRequest.getter(DeleteBotVersionRequest::skipResourceInUseCheck)).setter(DeleteBotVersionRequest.setter(Builder::skipResourceInUseCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, SKIP_RESOURCE_IN_USE_CHECK_FIELD));
    private final String botId;
    private final String botVersion;
    private final Boolean skipResourceInUseCheck;

    private DeleteBotVersionRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final Boolean skipResourceInUseCheck() {
        return this.skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipResourceInUseCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotVersionRequest)) {
            return false;
        }
        DeleteBotVersionRequest other = (DeleteBotVersionRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBotVersionRequest").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("SkipResourceInUseCheck", (Object)this.skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "skipResourceInUseCheck": {
                return Optional.ofNullable(clazz.cast(this.skipResourceInUseCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotVersionRequest, T> g) {
        return obj -> g.apply((DeleteBotVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotVersionRequest model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return this.skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBotVersionRequest build() {
            return new DeleteBotVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBotVersionRequest> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder skipResourceInUseCheck(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

