/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.CompatibleRuntimesCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishLayerVersionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, PublishLayerVersionResponse> {
    private static final SdkField<LayerVersionContentOutput> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::content)).setter(PublishLayerVersionResponse.setter(Builder::content)).constructor(LayerVersionContentOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> LAYER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::layerArn)).setter(PublishLayerVersionResponse.setter(Builder::layerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerArn").build()}).build();
    private static final SdkField<String> LAYER_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::layerVersionArn)).setter(PublishLayerVersionResponse.setter(Builder::layerVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersionArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::description)).setter(PublishLayerVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::createdDate)).setter(PublishLayerVersionResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::version)).setter(PublishLayerVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::compatibleRuntimesAsStrings)).setter(PublishLayerVersionResponse.setter(Builder::compatibleRuntimesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionResponse.getter(PublishLayerVersionResponse::licenseInfo)).setter(PublishLayerVersionResponse.setter(Builder::licenseInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, LAYER_ARN_FIELD, LAYER_VERSION_ARN_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD));
    private final LayerVersionContentOutput content;
    private final String layerArn;
    private final String layerVersionArn;
    private final String description;
    private final String createdDate;
    private final Long version;
    private final List<String> compatibleRuntimes;
    private final String licenseInfo;

    private PublishLayerVersionResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.layerArn = builder.layerArn;
        this.layerVersionArn = builder.layerVersionArn;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
    }

    public LayerVersionContentOutput content() {
        return this.content;
    }

    public String layerArn() {
        return this.layerArn;
    }

    public String layerVersionArn() {
        return this.layerVersionArn;
    }

    public String description() {
        return this.description;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public Long version() {
        return this.version;
    }

    public List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(this.compatibleRuntimes);
    }

    public boolean hasCompatibleRuntimes() {
        return this.compatibleRuntimes != null && !(this.compatibleRuntimes instanceof SdkAutoConstructList);
    }

    public List<String> compatibleRuntimesAsStrings() {
        return this.compatibleRuntimes;
    }

    public String licenseInfo() {
        return this.licenseInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleRuntimesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishLayerVersionResponse)) {
            return false;
        }
        PublishLayerVersionResponse other = (PublishLayerVersionResponse)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.layerArn(), other.layerArn()) && Objects.equals(this.layerVersionArn(), other.layerVersionArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings()) && Objects.equals(this.licenseInfo(), other.licenseInfo());
    }

    public String toString() {
        return ToString.builder((String)"PublishLayerVersionResponse").add("Content", (Object)this.content()).add("LayerArn", (Object)this.layerArn()).add("LayerVersionArn", (Object)this.layerVersionArn()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("CompatibleRuntimes", this.compatibleRuntimesAsStrings()).add("LicenseInfo", (Object)this.licenseInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "LayerArn": {
                return Optional.ofNullable(clazz.cast(this.layerArn()));
            }
            case "LayerVersionArn": {
                return Optional.ofNullable(clazz.cast(this.layerVersionArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CompatibleRuntimes": {
                return Optional.ofNullable(clazz.cast(this.compatibleRuntimesAsStrings()));
            }
            case "LicenseInfo": {
                return Optional.ofNullable(clazz.cast(this.licenseInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishLayerVersionResponse, T> g) {
        return obj -> g.apply((PublishLayerVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private LayerVersionContentOutput content;
        private String layerArn;
        private String layerVersionArn;
        private String description;
        private String createdDate;
        private Long version;
        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();
        private String licenseInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishLayerVersionResponse model) {
            super(model);
            this.content(model.content);
            this.layerArn(model.layerArn);
            this.layerVersionArn(model.layerVersionArn);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.compatibleRuntimesWithStrings(model.compatibleRuntimes);
            this.licenseInfo(model.licenseInfo);
        }

        public final LayerVersionContentOutput.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        @Override
        public final Builder content(LayerVersionContentOutput content) {
            this.content = content;
            return this;
        }

        public final void setContent(LayerVersionContentOutput.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final String getLayerArn() {
            return this.layerArn;
        }

        @Override
        public final Builder layerArn(String layerArn) {
            this.layerArn = layerArn;
            return this;
        }

        public final void setLayerArn(String layerArn) {
            this.layerArn = layerArn;
        }

        public final String getLayerVersionArn() {
            return this.layerVersionArn;
        }

        @Override
        public final Builder layerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        public final void setLayerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Collection<String> getCompatibleRuntimes() {
            return this.compatibleRuntimes;
        }

        @Override
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String ... compatibleRuntimes) {
            this.compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime ... compatibleRuntimes) {
            this.compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        public final String getLicenseInfo() {
            return this.licenseInfo;
        }

        @Override
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        public PublishLayerVersionResponse build() {
            return new PublishLayerVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishLayerVersionResponse> {
        public Builder content(LayerVersionContentOutput var1);

        default public Builder content(Consumer<LayerVersionContentOutput.Builder> content) {
            return this.content((LayerVersionContentOutput)((LayerVersionContentOutput.Builder)LayerVersionContentOutput.builder().applyMutation(content)).build());
        }

        public Builder layerArn(String var1);

        public Builder layerVersionArn(String var1);

        public Builder description(String var1);

        public Builder createdDate(String var1);

        public Builder version(Long var1);

        public Builder compatibleRuntimesWithStrings(Collection<String> var1);

        public Builder compatibleRuntimesWithStrings(String ... var1);

        public Builder compatibleRuntimes(Collection<Runtime> var1);

        public Builder compatibleRuntimes(Runtime ... var1);

        public Builder licenseInfo(String var1);
    }
}

