/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConfigurationUpdate> {
    private static final SdkField<String> VPC_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcConfigurationUpdate.getter(VpcConfigurationUpdate::vpcConfigurationId)).setter(VpcConfigurationUpdate.setter(Builder::vpcConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationId").build()}).build();
    private static final SdkField<List<String>> SUBNET_ID_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcConfigurationUpdate.getter(VpcConfigurationUpdate::subnetIdUpdates)).setter(VpcConfigurationUpdate.setter(Builder::subnetIdUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ID_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcConfigurationUpdate.getter(VpcConfigurationUpdate::securityGroupIdUpdates)).setter(VpcConfigurationUpdate.setter(Builder::securityGroupIdUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGURATION_ID_FIELD, SUBNET_ID_UPDATES_FIELD, SECURITY_GROUP_ID_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcConfigurationId;
    private final List<String> subnetIdUpdates;
    private final List<String> securityGroupIdUpdates;

    private VpcConfigurationUpdate(BuilderImpl builder) {
        this.vpcConfigurationId = builder.vpcConfigurationId;
        this.subnetIdUpdates = builder.subnetIdUpdates;
        this.securityGroupIdUpdates = builder.securityGroupIdUpdates;
    }

    public String vpcConfigurationId() {
        return this.vpcConfigurationId;
    }

    public boolean hasSubnetIdUpdates() {
        return this.subnetIdUpdates != null && !(this.subnetIdUpdates instanceof SdkAutoConstructList);
    }

    public List<String> subnetIdUpdates() {
        return this.subnetIdUpdates;
    }

    public boolean hasSecurityGroupIdUpdates() {
        return this.securityGroupIdUpdates != null && !(this.securityGroupIdUpdates instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIdUpdates() {
        return this.securityGroupIdUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIdUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigurationUpdate)) {
            return false;
        }
        VpcConfigurationUpdate other = (VpcConfigurationUpdate)obj;
        return Objects.equals(this.vpcConfigurationId(), other.vpcConfigurationId()) && Objects.equals(this.subnetIdUpdates(), other.subnetIdUpdates()) && Objects.equals(this.securityGroupIdUpdates(), other.securityGroupIdUpdates());
    }

    public String toString() {
        return ToString.builder((String)"VpcConfigurationUpdate").add("VpcConfigurationId", (Object)this.vpcConfigurationId()).add("SubnetIdUpdates", this.subnetIdUpdates()).add("SecurityGroupIdUpdates", this.securityGroupIdUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationId()));
            }
            case "SubnetIdUpdates": {
                return Optional.ofNullable(clazz.cast(this.subnetIdUpdates()));
            }
            case "SecurityGroupIdUpdates": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdUpdates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigurationUpdate, T> g) {
        return obj -> g.apply((VpcConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConfigurationId;
        private List<String> subnetIdUpdates = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIdUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigurationUpdate model) {
            this.vpcConfigurationId(model.vpcConfigurationId);
            this.subnetIdUpdates(model.subnetIdUpdates);
            this.securityGroupIdUpdates(model.securityGroupIdUpdates);
        }

        public final String getVpcConfigurationId() {
            return this.vpcConfigurationId;
        }

        @Override
        public final Builder vpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
            return this;
        }

        public final void setVpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
        }

        public final Collection<String> getSubnetIdUpdates() {
            return this.subnetIdUpdates;
        }

        @Override
        public final Builder subnetIdUpdates(Collection<String> subnetIdUpdates) {
            this.subnetIdUpdates = SubnetIdsCopier.copy(subnetIdUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIdUpdates(String ... subnetIdUpdates) {
            this.subnetIdUpdates(Arrays.asList(subnetIdUpdates));
            return this;
        }

        public final void setSubnetIdUpdates(Collection<String> subnetIdUpdates) {
            this.subnetIdUpdates = SubnetIdsCopier.copy(subnetIdUpdates);
        }

        public final Collection<String> getSecurityGroupIdUpdates() {
            return this.securityGroupIdUpdates;
        }

        @Override
        public final Builder securityGroupIdUpdates(Collection<String> securityGroupIdUpdates) {
            this.securityGroupIdUpdates = SecurityGroupIdsCopier.copy(securityGroupIdUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdUpdates(String ... securityGroupIdUpdates) {
            this.securityGroupIdUpdates(Arrays.asList(securityGroupIdUpdates));
            return this;
        }

        public final void setSecurityGroupIdUpdates(Collection<String> securityGroupIdUpdates) {
            this.securityGroupIdUpdates = SecurityGroupIdsCopier.copy(securityGroupIdUpdates);
        }

        public VpcConfigurationUpdate build() {
            return new VpcConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConfigurationUpdate> {
        public Builder vpcConfigurationId(String var1);

        public Builder subnetIdUpdates(Collection<String> var1);

        public Builder subnetIdUpdates(String ... var1);

        public Builder securityGroupIdUpdates(Collection<String> var1);

        public Builder securityGroupIdUpdates(String ... var1);
    }
}

