/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.SharePointUrlListCopier;
import software.amazon.awssdk.services.kendra.model.SharePointVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharePointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharePointConfiguration> {
    private static final SdkField<String> SHARE_POINT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SharePointConfiguration.getter(SharePointConfiguration::sharePointVersionAsString)).setter(SharePointConfiguration.setter(Builder::sharePointVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePointVersion").build()}).build();
    private static final SdkField<List<String>> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SharePointConfiguration.getter(SharePointConfiguration::urls)).setter(SharePointConfiguration.setter(Builder::urls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SharePointConfiguration.getter(SharePointConfiguration::secretArn)).setter(SharePointConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SharePointConfiguration.getter(SharePointConfiguration::crawlAttachments)).setter(SharePointConfiguration.setter(Builder::crawlAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()}).build();
    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SharePointConfiguration.getter(SharePointConfiguration::useChangeLog)).setter(SharePointConfiguration.setter(Builder::useChangeLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SharePointConfiguration.getter(SharePointConfiguration::inclusionPatterns)).setter(SharePointConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SharePointConfiguration.getter(SharePointConfiguration::exclusionPatterns)).setter(SharePointConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SharePointConfiguration.getter(SharePointConfiguration::vpcConfiguration)).setter(SharePointConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SharePointConfiguration.getter(SharePointConfiguration::fieldMappings)).setter(SharePointConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SharePointConfiguration.getter(SharePointConfiguration::documentTitleFieldName)).setter(SharePointConfiguration.setter(Builder::documentTitleFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_POINT_VERSION_FIELD, URLS_FIELD, SECRET_ARN_FIELD, CRAWL_ATTACHMENTS_FIELD, USE_CHANGE_LOG_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD, FIELD_MAPPINGS_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sharePointVersion;
    private final List<String> urls;
    private final String secretArn;
    private final Boolean crawlAttachments;
    private final Boolean useChangeLog;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;
    private final String documentTitleFieldName;

    private SharePointConfiguration(BuilderImpl builder) {
        this.sharePointVersion = builder.sharePointVersion;
        this.urls = builder.urls;
        this.secretArn = builder.secretArn;
        this.crawlAttachments = builder.crawlAttachments;
        this.useChangeLog = builder.useChangeLog;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.fieldMappings = builder.fieldMappings;
        this.documentTitleFieldName = builder.documentTitleFieldName;
    }

    public SharePointVersion sharePointVersion() {
        return SharePointVersion.fromValue(this.sharePointVersion);
    }

    public String sharePointVersionAsString() {
        return this.sharePointVersion;
    }

    public boolean hasUrls() {
        return this.urls != null && !(this.urls instanceof SdkAutoConstructList);
    }

    public List<String> urls() {
        return this.urls;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public Boolean crawlAttachments() {
        return this.crawlAttachments;
    }

    public Boolean useChangeLog() {
        return this.useChangeLog;
    }

    public boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public String documentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sharePointVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.urls());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleFieldName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointConfiguration)) {
            return false;
        }
        SharePointConfiguration other = (SharePointConfiguration)obj;
        return Objects.equals(this.sharePointVersionAsString(), other.sharePointVersionAsString()) && Objects.equals(this.urls(), other.urls()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.crawlAttachments(), other.crawlAttachments()) && Objects.equals(this.useChangeLog(), other.useChangeLog()) && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.fieldMappings(), other.fieldMappings()) && Objects.equals(this.documentTitleFieldName(), other.documentTitleFieldName());
    }

    public String toString() {
        return ToString.builder((String)"SharePointConfiguration").add("SharePointVersion", (Object)this.sharePointVersionAsString()).add("Urls", this.urls()).add("SecretArn", (Object)this.secretArn()).add("CrawlAttachments", (Object)this.crawlAttachments()).add("UseChangeLog", (Object)this.useChangeLog()).add("InclusionPatterns", this.inclusionPatterns()).add("ExclusionPatterns", this.exclusionPatterns()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("FieldMappings", this.fieldMappings()).add("DocumentTitleFieldName", (Object)this.documentTitleFieldName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SharePointVersion": {
                return Optional.ofNullable(clazz.cast(this.sharePointVersionAsString()));
            }
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "CrawlAttachments": {
                return Optional.ofNullable(clazz.cast(this.crawlAttachments()));
            }
            case "UseChangeLog": {
                return Optional.ofNullable(clazz.cast(this.useChangeLog()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
            case "DocumentTitleFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleFieldName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharePointConfiguration, T> g) {
        return obj -> g.apply((SharePointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sharePointVersion;
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String secretArn;
        private Boolean crawlAttachments;
        private Boolean useChangeLog;
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();
        private String documentTitleFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointConfiguration model) {
            this.sharePointVersion(model.sharePointVersion);
            this.urls(model.urls);
            this.secretArn(model.secretArn);
            this.crawlAttachments(model.crawlAttachments);
            this.useChangeLog(model.useChangeLog);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.vpcConfiguration(model.vpcConfiguration);
            this.fieldMappings(model.fieldMappings);
            this.documentTitleFieldName(model.documentTitleFieldName);
        }

        public final String getSharePointVersion() {
            return this.sharePointVersion;
        }

        @Override
        public final Builder sharePointVersion(String sharePointVersion) {
            this.sharePointVersion = sharePointVersion;
            return this;
        }

        @Override
        public final Builder sharePointVersion(SharePointVersion sharePointVersion) {
            this.sharePointVersion(sharePointVersion == null ? null : sharePointVersion.toString());
            return this;
        }

        public final void setSharePointVersion(String sharePointVersion) {
            this.sharePointVersion = sharePointVersion;
        }

        public final Collection<String> getUrls() {
            return this.urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = SharePointUrlListCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = SharePointUrlListCopier.copy(urls);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final Boolean getCrawlAttachments() {
            return this.crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final Boolean getUseChangeLog() {
            return this.useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        public final Collection<String> getInclusionPatterns() {
            return this.inclusionPatterns;
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        public final Collection<String> getExclusionPatterns() {
            return this.exclusionPatterns;
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        public final Collection<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            return this.fieldMappings != null ? (Collection)this.fieldMappings.stream().map(DataSourceToIndexFieldMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        public final String getDocumentTitleFieldName() {
            return this.documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        public SharePointConfiguration build() {
            return new SharePointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharePointConfiguration> {
        public Builder sharePointVersion(String var1);

        public Builder sharePointVersion(SharePointVersion var1);

        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder secretArn(String var1);

        public Builder crawlAttachments(Boolean var1);

        public Builder useChangeLog(Boolean var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder documentTitleFieldName(String var1);
    }
}

