/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPairListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FacetResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FacetResult> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FacetResult.getter(FacetResult::documentAttributeKey)).setter(FacetResult.setter(Builder::documentAttributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build()}).build();
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FacetResult.getter(FacetResult::documentAttributeValueTypeAsString)).setter(FacetResult.setter(Builder::documentAttributeValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValueType").build()}).build();
    private static final SdkField<List<DocumentAttributeValueCountPair>> DOCUMENT_ATTRIBUTE_VALUE_COUNT_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FacetResult.getter(FacetResult::documentAttributeValueCountPairs)).setter(FacetResult.setter(Builder::documentAttributeValueCountPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValueCountPairs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttributeValueCountPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD, DOCUMENT_ATTRIBUTE_VALUE_TYPE_FIELD, DOCUMENT_ATTRIBUTE_VALUE_COUNT_PAIRS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentAttributeKey;
    private final String documentAttributeValueType;
    private final List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs;

    private FacetResult(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.documentAttributeValueType = builder.documentAttributeValueType;
        this.documentAttributeValueCountPairs = builder.documentAttributeValueCountPairs;
    }

    public String documentAttributeKey() {
        return this.documentAttributeKey;
    }

    public DocumentAttributeValueType documentAttributeValueType() {
        return DocumentAttributeValueType.fromValue(this.documentAttributeValueType);
    }

    public String documentAttributeValueTypeAsString() {
        return this.documentAttributeValueType;
    }

    public boolean hasDocumentAttributeValueCountPairs() {
        return this.documentAttributeValueCountPairs != null && !(this.documentAttributeValueCountPairs instanceof SdkAutoConstructList);
    }

    public List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs() {
        return this.documentAttributeValueCountPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeValueCountPairs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetResult)) {
            return false;
        }
        FacetResult other = (FacetResult)obj;
        return Objects.equals(this.documentAttributeKey(), other.documentAttributeKey()) && Objects.equals(this.documentAttributeValueTypeAsString(), other.documentAttributeValueTypeAsString()) && Objects.equals(this.documentAttributeValueCountPairs(), other.documentAttributeValueCountPairs());
    }

    public String toString() {
        return ToString.builder((String)"FacetResult").add("DocumentAttributeKey", (Object)this.documentAttributeKey()).add("DocumentAttributeValueType", (Object)this.documentAttributeValueTypeAsString()).add("DocumentAttributeValueCountPairs", this.documentAttributeValueCountPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttributeKey": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeKey()));
            }
            case "DocumentAttributeValueType": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeValueTypeAsString()));
            }
            case "DocumentAttributeValueCountPairs": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeValueCountPairs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetResult, T> g) {
        return obj -> g.apply((FacetResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentAttributeKey;
        private String documentAttributeValueType;
        private List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FacetResult model) {
            this.documentAttributeKey(model.documentAttributeKey);
            this.documentAttributeValueType(model.documentAttributeValueType);
            this.documentAttributeValueCountPairs(model.documentAttributeValueCountPairs);
        }

        public final String getDocumentAttributeKey() {
            return this.documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        public final String getDocumentAttributeValueType() {
            return this.documentAttributeValueType;
        }

        @Override
        public final Builder documentAttributeValueType(String documentAttributeValueType) {
            this.documentAttributeValueType = documentAttributeValueType;
            return this;
        }

        @Override
        public final Builder documentAttributeValueType(DocumentAttributeValueType documentAttributeValueType) {
            this.documentAttributeValueType(documentAttributeValueType == null ? null : documentAttributeValueType.toString());
            return this;
        }

        public final void setDocumentAttributeValueType(String documentAttributeValueType) {
            this.documentAttributeValueType = documentAttributeValueType;
        }

        public final Collection<DocumentAttributeValueCountPair.Builder> getDocumentAttributeValueCountPairs() {
            return this.documentAttributeValueCountPairs != null ? (Collection)this.documentAttributeValueCountPairs.stream().map(DocumentAttributeValueCountPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentAttributeValueCountPairs(Collection<DocumentAttributeValueCountPair> documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs = DocumentAttributeValueCountPairListCopier.copy(documentAttributeValueCountPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeValueCountPairs(DocumentAttributeValueCountPair ... documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs(Arrays.asList(documentAttributeValueCountPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeValueCountPairs(Consumer<DocumentAttributeValueCountPair.Builder> ... documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs(Stream.of(documentAttributeValueCountPairs).map(c -> (DocumentAttributeValueCountPair)((DocumentAttributeValueCountPair.Builder)DocumentAttributeValueCountPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentAttributeValueCountPairs(Collection<DocumentAttributeValueCountPair.BuilderImpl> documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs = DocumentAttributeValueCountPairListCopier.copyFromBuilder(documentAttributeValueCountPairs);
        }

        public FacetResult build() {
            return new FacetResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FacetResult> {
        public Builder documentAttributeKey(String var1);

        public Builder documentAttributeValueType(String var1);

        public Builder documentAttributeValueType(DocumentAttributeValueType var1);

        public Builder documentAttributeValueCountPairs(Collection<DocumentAttributeValueCountPair> var1);

        public Builder documentAttributeValueCountPairs(DocumentAttributeValueCountPair ... var1);

        public Builder documentAttributeValueCountPairs(Consumer<DocumentAttributeValueCountPair.Builder> ... var1);
    }
}

