/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ConfigurationInfo;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterConfigurationRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateClusterConfigurationRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateClusterConfigurationRequest.getter(UpdateClusterConfigurationRequest::clusterArn)).setter(UpdateClusterConfigurationRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationInfo").getter(UpdateClusterConfigurationRequest.getter(UpdateClusterConfigurationRequest::configurationInfo)).setter(UpdateClusterConfigurationRequest.setter(Builder::configurationInfo)).constructor(ConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateClusterConfigurationRequest.getter(UpdateClusterConfigurationRequest::currentVersion)).setter(UpdateClusterConfigurationRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CONFIGURATION_INFO_FIELD, CURRENT_VERSION_FIELD));
    private final String clusterArn;
    private final ConfigurationInfo configurationInfo;
    private final String currentVersion;

    private UpdateClusterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.configurationInfo = builder.configurationInfo;
        this.currentVersion = builder.currentVersion;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final ConfigurationInfo configurationInfo() {
        return this.configurationInfo;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigurationRequest)) {
            return false;
        }
        UpdateClusterConfigurationRequest other = (UpdateClusterConfigurationRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.configurationInfo(), other.configurationInfo()) && Objects.equals(this.currentVersion(), other.currentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterConfigurationRequest").add("ClusterArn", (Object)this.clusterArn()).add("ConfigurationInfo", (Object)this.configurationInfo()).add("CurrentVersion", (Object)this.currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ConfigurationInfo": {
                return Optional.ofNullable(clazz.cast(this.configurationInfo()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private ConfigurationInfo configurationInfo;
        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigurationRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.configurationInfo(model.configurationInfo);
            this.currentVersion(model.currentVersion);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return this.configurationInfo != null ? this.configurationInfo.toBuilder() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigurationRequest build() {
            return new UpdateClusterConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterConfigurationRequest> {
        public Builder clusterArn(String var1);

        public Builder configurationInfo(ConfigurationInfo var1);

        default public Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return this.configurationInfo((ConfigurationInfo)((ConfigurationInfo.Builder)ConfigurationInfo.builder().applyMutation(configurationInfo)).build());
        }

        public Builder currentVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

