/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.ClusterState;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoring;
import software.amazon.awssdk.services.kafka.model.StateInfo;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInfo> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveOperationArn").getter(ClusterInfo.getter(ClusterInfo::activeOperationArn)).setter(ClusterInfo.setter(Builder::activeOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build()}).build();
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo").getter(ClusterInfo.getter(ClusterInfo::brokerNodeGroupInfo)).setter(ClusterInfo.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(ClusterInfo.getter(ClusterInfo::clientAuthentication)).setter(ClusterInfo.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterInfo.getter(ClusterInfo::clusterArn)).setter(ClusterInfo.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ClusterInfo.getter(ClusterInfo::clusterName)).setter(ClusterInfo.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClusterInfo.getter(ClusterInfo::creationTime)).setter(ClusterInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo").getter(ClusterInfo.getter(ClusterInfo::currentBrokerSoftwareInfo)).setter(ClusterInfo.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(ClusterInfo.getter(ClusterInfo::currentVersion)).setter(ClusterInfo.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(ClusterInfo.getter(ClusterInfo::encryptionInfo)).setter(ClusterInfo.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(ClusterInfo.getter(ClusterInfo::enhancedMonitoringAsString)).setter(ClusterInfo.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(ClusterInfo.getter(ClusterInfo::openMonitoring)).setter(ClusterInfo.setter(Builder::openMonitoring)).constructor(OpenMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(ClusterInfo.getter(ClusterInfo::loggingInfo)).setter(ClusterInfo.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBrokerNodes").getter(ClusterInfo.getter(ClusterInfo::numberOfBrokerNodes)).setter(ClusterInfo.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ClusterInfo.getter(ClusterInfo::stateAsString)).setter(ClusterInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<StateInfo> STATE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateInfo").getter(ClusterInfo.getter(ClusterInfo::stateInfo)).setter(ClusterInfo.setter(Builder::stateInfo)).constructor(StateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ClusterInfo.getter(ClusterInfo::tags)).setter(ClusterInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectString").getter(ClusterInfo.getter(ClusterInfo::zookeeperConnectString)).setter(ClusterInfo.setter(Builder::zookeeperConnectString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectStringTls").getter(ClusterInfo.getter(ClusterInfo::zookeeperConnectStringTls)).setter(ClusterInfo.setter(Builder::zookeeperConnectStringTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD, BROKER_NODE_GROUP_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, STATE_FIELD, STATE_INFO_FIELD, TAGS_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD, ZOOKEEPER_CONNECT_STRING_TLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeOperationArn;
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final ClientAuthentication clientAuthentication;
    private final String clusterArn;
    private final String clusterName;
    private final Instant creationTime;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final String currentVersion;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final OpenMonitoring openMonitoring;
    private final LoggingInfo loggingInfo;
    private final Integer numberOfBrokerNodes;
    private final String state;
    private final StateInfo stateInfo;
    private final Map<String, String> tags;
    private final String zookeeperConnectString;
    private final String zookeeperConnectStringTls;

    private ClusterInfo(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.state = builder.state;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
    }

    public final String activeOperationArn() {
        return this.activeOperationArn;
    }

    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoring openMonitoring() {
        return this.openMonitoring;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public final ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StateInfo stateInfo() {
        return this.stateInfo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String zookeeperConnectString() {
        return this.zookeeperConnectString;
    }

    public final String zookeeperConnectStringTls() {
        return this.zookeeperConnectStringTls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectStringTls());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)obj;
        return Objects.equals(this.activeOperationArn(), other.activeOperationArn()) && Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateInfo(), other.stateInfo()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.zookeeperConnectString(), other.zookeeperConnectString()) && Objects.equals(this.zookeeperConnectStringTls(), other.zookeeperConnectStringTls());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInfo").add("ActiveOperationArn", (Object)this.activeOperationArn()).add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("ClientAuthentication", (Object)this.clientAuthentication()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("CreationTime", (Object)this.creationTime()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("CurrentVersion", (Object)this.currentVersion()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("State", (Object)this.stateAsString()).add("StateInfo", (Object)this.stateInfo()).add("Tags", this.hasTags() ? this.tags() : null).add("ZookeeperConnectString", (Object)this.zookeeperConnectString()).add("ZookeeperConnectStringTls", (Object)this.zookeeperConnectStringTls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveOperationArn": {
                return Optional.ofNullable(clazz.cast(this.activeOperationArn()));
            }
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateInfo": {
                return Optional.ofNullable(clazz.cast(this.stateInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ZookeeperConnectString": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectString()));
            }
            case "ZookeeperConnectStringTls": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectStringTls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInfo, T> g) {
        return obj -> g.apply((ClusterInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeOperationArn;
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private ClientAuthentication clientAuthentication;
        private String clusterArn;
        private String clusterName;
        private Instant creationTime;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private String currentVersion;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private OpenMonitoring openMonitoring;
        private LoggingInfo loggingInfo;
        private Integer numberOfBrokerNodes;
        private String state;
        private StateInfo stateInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String zookeeperConnectString;
        private String zookeeperConnectStringTls;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInfo model) {
            this.activeOperationArn(model.activeOperationArn);
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.clientAuthentication(model.clientAuthentication);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.creationTime(model.creationTime);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.currentVersion(model.currentVersion);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.state(model.state);
            this.stateInfo(model.stateInfo);
            this.tags(model.tags);
            this.zookeeperConnectString(model.zookeeperConnectString);
            this.zookeeperConnectStringTls(model.zookeeperConnectStringTls);
        }

        public final String getActiveOperationArn() {
            return this.activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final StateInfo.Builder getStateInfo() {
            return this.stateInfo != null ? this.stateInfo.toBuilder() : null;
        }

        @Override
        public final Builder stateInfo(StateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final void setStateInfo(StateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getZookeeperConnectString() {
            return this.zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        public final String getZookeeperConnectStringTls() {
            return this.zookeeperConnectStringTls;
        }

        @Override
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        public ClusterInfo build() {
            return new ClusterInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInfo> {
        public Builder activeOperationArn(String var1);

        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder currentVersion(String var1);

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoring var1);

        default public Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoring)((OpenMonitoring.Builder)OpenMonitoring.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateInfo(StateInfo var1);

        default public Builder stateInfo(Consumer<StateInfo.Builder> stateInfo) {
            return this.stateInfo((StateInfo)((StateInfo.Builder)StateInfo.builder().applyMutation(stateInfo)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder zookeeperConnectString(String var1);

        public Builder zookeeperConnectStringTls(String var1);
    }
}

