/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN device metatdata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANDeviceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANDeviceMetadata.Builder, LoRaWANDeviceMetadata> {
    private static final SdkField<String> DEV_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DevEui")
            .getter(getter(LoRaWANDeviceMetadata::devEui)).setter(setter(Builder::devEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEui").build()).build();

    private static final SdkField<Integer> F_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("FPort")
            .getter(getter(LoRaWANDeviceMetadata::fPort)).setter(setter(Builder::fPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()).build();

    private static final SdkField<Integer> DATA_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRate").getter(getter(LoRaWANDeviceMetadata::dataRate)).setter(setter(Builder::dataRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRate").build()).build();

    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Frequency").getter(getter(LoRaWANDeviceMetadata::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timestamp").getter(getter(LoRaWANDeviceMetadata::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<List<LoRaWANGatewayMetadata>> GATEWAYS_FIELD = SdkField
            .<List<LoRaWANGatewayMetadata>> builder(MarshallingType.LIST)
            .memberName("Gateways")
            .getter(getter(LoRaWANDeviceMetadata::gateways))
            .setter(setter(Builder::gateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoRaWANGatewayMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoRaWANGatewayMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_EUI_FIELD, F_PORT_FIELD,
            DATA_RATE_FIELD, FREQUENCY_FIELD, TIMESTAMP_FIELD, GATEWAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String devEui;

    private final Integer fPort;

    private final Integer dataRate;

    private final Integer frequency;

    private final String timestamp;

    private final List<LoRaWANGatewayMetadata> gateways;

    private LoRaWANDeviceMetadata(BuilderImpl builder) {
        this.devEui = builder.devEui;
        this.fPort = builder.fPort;
        this.dataRate = builder.dataRate;
        this.frequency = builder.frequency;
        this.timestamp = builder.timestamp;
        this.gateways = builder.gateways;
    }

    /**
     * <p>
     * The DevEUI value.
     * </p>
     * 
     * @return The DevEUI value.
     */
    public final String devEui() {
        return devEui;
    }

    /**
     * <p>
     * The FPort value.
     * </p>
     * 
     * @return The FPort value.
     */
    public final Integer fPort() {
        return fPort;
    }

    /**
     * <p>
     * The DataRate value.
     * </p>
     * 
     * @return The DataRate value.
     */
    public final Integer dataRate() {
        return dataRate;
    }

    /**
     * <p>
     * The device's channel frequency in Hz.
     * </p>
     * 
     * @return The device's channel frequency in Hz.
     */
    public final Integer frequency() {
        return frequency;
    }

    /**
     * <p>
     * The date and time of the metadata.
     * </p>
     * 
     * @return The date and time of the metadata.
     */
    public final String timestamp() {
        return timestamp;
    }

    /**
     * Returns true if the Gateways property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGateways() {
        return gateways != null && !(gateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the gateways accessed by the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the gateways accessed by the device.
     */
    public final List<LoRaWANGatewayMetadata> gateways() {
        return gateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devEui());
        hashCode = 31 * hashCode + Objects.hashCode(fPort());
        hashCode = 31 * hashCode + Objects.hashCode(dataRate());
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasGateways() ? gateways() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDeviceMetadata)) {
            return false;
        }
        LoRaWANDeviceMetadata other = (LoRaWANDeviceMetadata) obj;
        return Objects.equals(devEui(), other.devEui()) && Objects.equals(fPort(), other.fPort())
                && Objects.equals(dataRate(), other.dataRate()) && Objects.equals(frequency(), other.frequency())
                && Objects.equals(timestamp(), other.timestamp()) && hasGateways() == other.hasGateways()
                && Objects.equals(gateways(), other.gateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANDeviceMetadata").add("DevEui", devEui()).add("FPort", fPort())
                .add("DataRate", dataRate()).add("Frequency", frequency()).add("Timestamp", timestamp())
                .add("Gateways", hasGateways() ? gateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEui":
            return Optional.ofNullable(clazz.cast(devEui()));
        case "FPort":
            return Optional.ofNullable(clazz.cast(fPort()));
        case "DataRate":
            return Optional.ofNullable(clazz.cast(dataRate()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Gateways":
            return Optional.ofNullable(clazz.cast(gateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDeviceMetadata, T> g) {
        return obj -> g.apply((LoRaWANDeviceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANDeviceMetadata> {
        /**
         * <p>
         * The DevEUI value.
         * </p>
         * 
         * @param devEui
         *        The DevEUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEui(String devEui);

        /**
         * <p>
         * The FPort value.
         * </p>
         * 
         * @param fPort
         *        The FPort value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPort(Integer fPort);

        /**
         * <p>
         * The DataRate value.
         * </p>
         * 
         * @param dataRate
         *        The DataRate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRate(Integer dataRate);

        /**
         * <p>
         * The device's channel frequency in Hz.
         * </p>
         * 
         * @param frequency
         *        The device's channel frequency in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(Integer frequency);

        /**
         * <p>
         * The date and time of the metadata.
         * </p>
         * 
         * @param timestamp
         *        The date and time of the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * Information about the gateways accessed by the device.
         * </p>
         * 
         * @param gateways
         *        Information about the gateways accessed by the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(Collection<LoRaWANGatewayMetadata> gateways);

        /**
         * <p>
         * Information about the gateways accessed by the device.
         * </p>
         * 
         * @param gateways
         *        Information about the gateways accessed by the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(LoRaWANGatewayMetadata... gateways);

        /**
         * <p>
         * Information about the gateways accessed by the device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoRaWANGatewayMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<LoRaWANGatewayMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoRaWANGatewayMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #gateways(List<LoRaWANGatewayMetadata>)}.
         * 
         * @param gateways
         *        a consumer that will call methods on {@link List<LoRaWANGatewayMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gateways(List<LoRaWANGatewayMetadata>)
         */
        Builder gateways(Consumer<LoRaWANGatewayMetadata.Builder>... gateways);
    }

    static final class BuilderImpl implements Builder {
        private String devEui;

        private Integer fPort;

        private Integer dataRate;

        private Integer frequency;

        private String timestamp;

        private List<LoRaWANGatewayMetadata> gateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDeviceMetadata model) {
            devEui(model.devEui);
            fPort(model.fPort);
            dataRate(model.dataRate);
            frequency(model.frequency);
            timestamp(model.timestamp);
            gateways(model.gateways);
        }

        public final String getDevEui() {
            return devEui;
        }

        @Override
        public final Builder devEui(String devEui) {
            this.devEui = devEui;
            return this;
        }

        public final void setDevEui(String devEui) {
            this.devEui = devEui;
        }

        public final Integer getFPort() {
            return fPort;
        }

        @Override
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        public final Integer getDataRate() {
            return dataRate;
        }

        @Override
        public final Builder dataRate(Integer dataRate) {
            this.dataRate = dataRate;
            return this;
        }

        public final void setDataRate(Integer dataRate) {
            this.dataRate = dataRate;
        }

        public final Integer getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final List<LoRaWANGatewayMetadata.Builder> getGateways() {
            List<LoRaWANGatewayMetadata.Builder> result = LoRaWANGatewayMetadataListCopier.copyToBuilder(this.gateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder gateways(Collection<LoRaWANGatewayMetadata> gateways) {
            this.gateways = LoRaWANGatewayMetadataListCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(LoRaWANGatewayMetadata... gateways) {
            gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<LoRaWANGatewayMetadata.Builder>... gateways) {
            gateways(Stream.of(gateways).map(c -> LoRaWANGatewayMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGateways(Collection<LoRaWANGatewayMetadata.BuilderImpl> gateways) {
            this.gateways = LoRaWANGatewayMetadataListCopier.copyFromBuilder(gateways);
        }

        @Override
        public LoRaWANDeviceMetadata build() {
            return new LoRaWANDeviceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
