/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPartnerAccountResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetPartnerAccountResponse.Builder, GetPartnerAccountResponse> {
    private static final SdkField<SidewalkAccountInfoWithFingerprint> SIDEWALK_FIELD = SdkField
            .<SidewalkAccountInfoWithFingerprint> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(GetPartnerAccountResponse::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkAccountInfoWithFingerprint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final SdkField<Boolean> ACCOUNT_LINKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccountLinked").getter(getter(GetPartnerAccountResponse::accountLinked))
            .setter(setter(Builder::accountLinked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD,
            ACCOUNT_LINKED_FIELD));

    private final SidewalkAccountInfoWithFingerprint sidewalk;

    private final Boolean accountLinked;

    private GetPartnerAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.accountLinked = builder.accountLinked;
    }

    /**
     * <p>
     * The Sidewalk account credentials.
     * </p>
     * 
     * @return The Sidewalk account credentials.
     */
    public final SidewalkAccountInfoWithFingerprint sidewalk() {
        return sidewalk;
    }

    /**
     * <p>
     * Whether the partner account is linked to the AWS account.
     * </p>
     * 
     * @return Whether the partner account is linked to the AWS account.
     */
    public final Boolean accountLinked() {
        return accountLinked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(accountLinked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartnerAccountResponse)) {
            return false;
        }
        GetPartnerAccountResponse other = (GetPartnerAccountResponse) obj;
        return Objects.equals(sidewalk(), other.sidewalk()) && Objects.equals(accountLinked(), other.accountLinked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPartnerAccountResponse").add("Sidewalk", sidewalk()).add("AccountLinked", accountLinked())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        case "AccountLinked":
            return Optional.ofNullable(clazz.cast(accountLinked()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartnerAccountResponse, T> g) {
        return obj -> g.apply((GetPartnerAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPartnerAccountResponse> {
        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk account credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkAccountInfoWithFingerprint sidewalk);

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * This is a convenience that creates an instance of the {@link SidewalkAccountInfoWithFingerprint.Builder}
         * avoiding the need to create one manually via {@link SidewalkAccountInfoWithFingerprint#builder()}.
         *
         * When the {@link Consumer} completes, {@link SidewalkAccountInfoWithFingerprint.Builder#build()} is called
         * immediately and its result is passed to {@link #sidewalk(SidewalkAccountInfoWithFingerprint)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkAccountInfoWithFingerprint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkAccountInfoWithFingerprint)
         */
        default Builder sidewalk(Consumer<SidewalkAccountInfoWithFingerprint.Builder> sidewalk) {
            return sidewalk(SidewalkAccountInfoWithFingerprint.builder().applyMutation(sidewalk).build());
        }

        /**
         * <p>
         * Whether the partner account is linked to the AWS account.
         * </p>
         * 
         * @param accountLinked
         *        Whether the partner account is linked to the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLinked(Boolean accountLinked);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private SidewalkAccountInfoWithFingerprint sidewalk;

        private Boolean accountLinked;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartnerAccountResponse model) {
            super(model);
            sidewalk(model.sidewalk);
            accountLinked(model.accountLinked);
        }

        public final SidewalkAccountInfoWithFingerprint.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfoWithFingerprint sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkAccountInfoWithFingerprint.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        public final Boolean getAccountLinked() {
            return accountLinked;
        }

        @Override
        public final Builder accountLinked(Boolean accountLinked) {
            this.accountLinked = accountLinked;
            return this;
        }

        public final void setAccountLinked(Boolean accountLinked) {
            this.accountLinked = accountLinked;
        }

        @Override
        public GetPartnerAccountResponse build() {
            return new GetPartnerAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
