/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWirelessGatewayWithCertificateRequest extends IotWirelessRequest implements
        ToCopyableBuilder<AssociateWirelessGatewayWithCertificateRequest.Builder, AssociateWirelessGatewayWithCertificateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AssociateWirelessGatewayWithCertificateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> IOT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotCertificateId").getter(getter(AssociateWirelessGatewayWithCertificateRequest::iotCertificateId))
            .setter(setter(Builder::iotCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotCertificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            IOT_CERTIFICATE_ID_FIELD));

    private final String id;

    private final String iotCertificateId;

    private AssociateWirelessGatewayWithCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.iotCertificateId = builder.iotCertificateId;
    }

    /**
     * <p>
     * The ID of the resource to update.
     * </p>
     * 
     * @return The ID of the resource to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the certificate to associate with the wireless gateway.
     * </p>
     * 
     * @return The ID of the certificate to associate with the wireless gateway.
     */
    public final String iotCertificateId() {
        return iotCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(iotCertificateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWirelessGatewayWithCertificateRequest)) {
            return false;
        }
        AssociateWirelessGatewayWithCertificateRequest other = (AssociateWirelessGatewayWithCertificateRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(iotCertificateId(), other.iotCertificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWirelessGatewayWithCertificateRequest").add("Id", id())
                .add("IotCertificateId", iotCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IotCertificateId":
            return Optional.ofNullable(clazz.cast(iotCertificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWirelessGatewayWithCertificateRequest, T> g) {
        return obj -> g.apply((AssociateWirelessGatewayWithCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWirelessGatewayWithCertificateRequest> {
        /**
         * <p>
         * The ID of the resource to update.
         * </p>
         * 
         * @param id
         *        The ID of the resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the certificate to associate with the wireless gateway.
         * </p>
         * 
         * @param iotCertificateId
         *        The ID of the certificate to associate with the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotCertificateId(String iotCertificateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String iotCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWirelessGatewayWithCertificateRequest model) {
            super(model);
            id(model.id);
            iotCertificateId(model.iotCertificateId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIotCertificateId() {
            return iotCertificateId;
        }

        @Override
        public final Builder iotCertificateId(String iotCertificateId) {
            this.iotCertificateId = iotCertificateId;
            return this;
        }

        public final void setIotCertificateId(String iotCertificateId) {
            this.iotCertificateId = iotCertificateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWirelessGatewayWithCertificateRequest build() {
            return new AssociateWirelessGatewayWithCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
