/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest;
import software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest;
import software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest;
import software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskRequest;
import software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.TagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.TagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotwireless.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdatePartnerAccountResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayResponse;
import software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher;
import software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher;

/**
 * Service client for accessing AWS IoT Wireless asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS IoT Wireless API documentation
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotWirelessAsyncClient extends SdkClient {
    String SERVICE_NAME = "iotwireless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotwireless";

    /**
     * Create a {@link IotWirelessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotWirelessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotWirelessAsyncClient}.
     */
    static IotWirelessAsyncClientBuilder builder() {
        return new DefaultIotWirelessAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            AssociateAwsAccountWithPartnerAccountRequest associateAwsAccountWithPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a partner account with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateAwsAccountWithPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateAwsAccountWithPartnerAccountRequest#builder()}
     * </p>
     *
     * @param associateAwsAccountWithPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAwsAccountWithPartnerAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateAwsAccountWithPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateAwsAccountWithPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateAwsAccountWithPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAwsAccountWithPartnerAccountResponse> associateAwsAccountWithPartnerAccount(
            Consumer<AssociateAwsAccountWithPartnerAccountRequest.Builder> associateAwsAccountWithPartnerAccountRequest) {
        return associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.builder()
                .applyMutation(associateAwsAccountWithPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            AssociateWirelessDeviceWithThingRequest associateWirelessDeviceWithThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless device with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessDeviceWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessDeviceWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessDeviceWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessDeviceWithThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateWirelessDeviceWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessDeviceWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessDeviceWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessDeviceWithThingResponse> associateWirelessDeviceWithThing(
            Consumer<AssociateWirelessDeviceWithThingRequest.Builder> associateWirelessDeviceWithThingRequest) {
        return associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.builder()
                .applyMutation(associateWirelessDeviceWithThingRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            AssociateWirelessGatewayWithCertificateRequest associateWirelessGatewayWithCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWirelessGatewayWithCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWirelessGatewayWithCertificateRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateWirelessGatewayWithCertificateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithCertificate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithCertificateResponse> associateWirelessGatewayWithCertificate(
            Consumer<AssociateWirelessGatewayWithCertificateRequest.Builder> associateWirelessGatewayWithCertificateRequest) {
        return associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.builder()
                .applyMutation(associateWirelessGatewayWithCertificateRequest).build());
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            AssociateWirelessGatewayWithThingRequest associateWirelessGatewayWithThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a wireless gateway with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWirelessGatewayWithThingRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWirelessGatewayWithThingRequest#builder()}
     * </p>
     *
     * @param associateWirelessGatewayWithThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWirelessGatewayWithThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateWirelessGatewayWithThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.AssociateWirelessGatewayWithThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/AssociateWirelessGatewayWithThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWirelessGatewayWithThingResponse> associateWirelessGatewayWithThing(
            Consumer<AssociateWirelessGatewayWithThingRequest.Builder> associateWirelessGatewayWithThingRequest) {
        return associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.builder()
                .applyMutation(associateWirelessGatewayWithThingRequest).build());
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new destination that maps a device message to an AWS IoT rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(
            Consumer<CreateDestinationRequest.Builder> createDestinationRequest) {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     *
     * @param createDeviceProfileRequest
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            CreateDeviceProfileRequest createDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceProfileRequest#builder()}
     * </p>
     *
     * @param createDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceProfileResponse> createDeviceProfile(
            Consumer<CreateDeviceProfileRequest.Builder> createDeviceProfileRequest) {
        return createDeviceProfile(CreateDeviceProfileRequest.builder().applyMutation(createDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     *
     * @param createServiceProfileRequest
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            CreateServiceProfileRequest createServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceProfileRequest#builder()}
     * </p>
     *
     * @param createServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateServiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceProfileResponse> createServiceProfile(
            Consumer<CreateServiceProfileRequest.Builder> createServiceProfileRequest) {
        return createServiceProfile(CreateServiceProfileRequest.builder().applyMutation(createServiceProfileRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     *
     * @param createWirelessDeviceRequest
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            CreateWirelessDeviceRequest createWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param createWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessDeviceResponse> createWirelessDevice(
            Consumer<CreateWirelessDeviceRequest.Builder> createWirelessDeviceRequest) {
        return createWirelessDevice(CreateWirelessDeviceRequest.builder().applyMutation(createWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayRequest
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            CreateWirelessGatewayRequest createWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayResponse> createWirelessGateway(
            Consumer<CreateWirelessGatewayRequest.Builder> createWirelessGatewayRequest) {
        return createWirelessGateway(CreateWirelessGatewayRequest.builder().applyMutation(createWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            CreateWirelessGatewayTaskRequest createWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a task for a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskResponse> createWirelessGatewayTask(
            Consumer<CreateWirelessGatewayTaskRequest.Builder> createWirelessGatewayTaskRequest) {
        return createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.builder()
                .applyMutation(createWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            CreateWirelessGatewayTaskDefinitionRequest createWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param createWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.CreateWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWirelessGatewayTaskDefinitionResponse> createWirelessGatewayTaskDefinition(
            Consumer<CreateWirelessGatewayTaskDefinitionRequest.Builder> createWirelessGatewayTaskDefinitionRequest) {
        return createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(createWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(
            Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest) {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     *
     * @param deleteDeviceProfileRequest
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            DeleteDeviceProfileRequest deleteDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceProfileRequest#builder()}
     * </p>
     *
     * @param deleteDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteDeviceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceProfileResponse> deleteDeviceProfile(
            Consumer<DeleteDeviceProfileRequest.Builder> deleteDeviceProfileRequest) {
        return deleteDeviceProfile(DeleteDeviceProfileRequest.builder().applyMutation(deleteDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     *
     * @param deleteServiceProfileRequest
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            DeleteServiceProfileRequest deleteServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceProfileRequest#builder()}
     * </p>
     *
     * @param deleteServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteServiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceProfileResponse> deleteServiceProfile(
            Consumer<DeleteServiceProfileRequest.Builder> deleteServiceProfileRequest) {
        return deleteServiceProfile(DeleteServiceProfileRequest.builder().applyMutation(deleteServiceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            DeleteWirelessDeviceRequest deleteWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param deleteWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessDeviceResponse> deleteWirelessDevice(
            Consumer<DeleteWirelessDeviceRequest.Builder> deleteWirelessDeviceRequest) {
        return deleteWirelessDevice(DeleteWirelessDeviceRequest.builder().applyMutation(deleteWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            DeleteWirelessGatewayRequest deleteWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayResponse> deleteWirelessGateway(
            Consumer<DeleteWirelessGatewayRequest.Builder> deleteWirelessGatewayRequest) {
        return deleteWirelessGateway(DeleteWirelessGatewayRequest.builder().applyMutation(deleteWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            DeleteWirelessGatewayTaskRequest deleteWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskResponse> deleteWirelessGatewayTask(
            Consumer<DeleteWirelessGatewayTaskRequest.Builder> deleteWirelessGatewayTaskRequest) {
        return deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskRequest).build());
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            DeleteWirelessGatewayTaskDefinitionRequest deleteWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are
     * currently in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DeleteWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DeleteWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWirelessGatewayTaskDefinitionResponse> deleteWirelessGatewayTaskDefinition(
            Consumer<DeleteWirelessGatewayTaskDefinitionRequest.Builder> deleteWirelessGatewayTaskDefinitionRequest) {
        return deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(deleteWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            DisassociateAwsAccountFromPartnerAccountRequest disassociateAwsAccountFromPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and
     * <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateAwsAccountFromPartnerAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAwsAccountFromPartnerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateAwsAccountFromPartnerAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateAwsAccountFromPartnerAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateAwsAccountFromPartnerAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateAwsAccountFromPartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAwsAccountFromPartnerAccountResponse> disassociateAwsAccountFromPartnerAccount(
            Consumer<DisassociateAwsAccountFromPartnerAccountRequest.Builder> disassociateAwsAccountFromPartnerAccountRequest) {
        return disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.builder()
                .applyMutation(disassociateAwsAccountFromPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            DisassociateWirelessDeviceFromThingRequest disassociateWirelessDeviceFromThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless device from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWirelessDeviceFromThingRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWirelessDeviceFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessDeviceFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessDeviceFromThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateWirelessDeviceFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessDeviceFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessDeviceFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessDeviceFromThingResponse> disassociateWirelessDeviceFromThing(
            Consumer<DisassociateWirelessDeviceFromThingRequest.Builder> disassociateWirelessDeviceFromThingRequest) {
        return disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.builder()
                .applyMutation(disassociateWirelessDeviceFromThingRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            DisassociateWirelessGatewayFromCertificateRequest disassociateWirelessGatewayFromCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateWirelessGatewayFromCertificateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromCertificate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromCertificateResponse> disassociateWirelessGatewayFromCertificate(
            Consumer<DisassociateWirelessGatewayFromCertificateRequest.Builder> disassociateWirelessGatewayFromCertificateRequest) {
        return disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromCertificateRequest).build());
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            DisassociateWirelessGatewayFromThingRequest disassociateWirelessGatewayFromThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a wireless gateway from its currently associated thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWirelessGatewayFromThingRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWirelessGatewayFromThingRequest#builder()}
     * </p>
     *
     * @param disassociateWirelessGatewayFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWirelessGatewayFromThingRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWirelessGatewayFromThing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.DisassociateWirelessGatewayFromThing
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/DisassociateWirelessGatewayFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWirelessGatewayFromThingResponse> disassociateWirelessGatewayFromThing(
            Consumer<DisassociateWirelessGatewayFromThingRequest.Builder> disassociateWirelessGatewayFromThingRequest) {
        return disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.builder()
                .applyMutation(disassociateWirelessGatewayFromThingRequest).build());
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on {@link GetDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest) {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     *
     * @param getDeviceProfileRequest
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(GetDeviceProfileRequest getDeviceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceProfileRequest#builder()}
     * </p>
     *
     * @param getDeviceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeviceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetDeviceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetDeviceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceProfileResponse> getDeviceProfile(
            Consumer<GetDeviceProfileRequest.Builder> getDeviceProfileRequest) {
        return getDeviceProfile(GetDeviceProfileRequest.builder().applyMutation(getDeviceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     *
     * @param getPartnerAccountRequest
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(GetPartnerAccountRequest getPartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are
     * <code>null</code>, returns all partner accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnerAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetPartnerAccountRequest#builder()}
     * </p>
     *
     * @param getPartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetPartnerAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetPartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetPartnerAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPartnerAccountResponse> getPartnerAccount(
            Consumer<GetPartnerAccountRequest.Builder> getPartnerAccountRequest) {
        return getPartnerAccount(GetPartnerAccountRequest.builder().applyMutation(getPartnerAccountRequest).build());
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     *
     * @param getServiceEndpointRequest
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(GetServiceEndpointRequest getServiceEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server
     * (LNS) connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceEndpointRequest#builder()}
     * </p>
     *
     * @param getServiceEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceEndpointResponse> getServiceEndpoint(
            Consumer<GetServiceEndpointRequest.Builder> getServiceEndpointRequest) {
        return getServiceEndpoint(GetServiceEndpointRequest.builder().applyMutation(getServiceEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     *
     * @param getServiceProfileRequest
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceProfileResponse> getServiceProfile(GetServiceProfileRequest getServiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a service profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceProfileRequest#builder()}
     * </p>
     *
     * @param getServiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetServiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetServiceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceProfileResponse> getServiceProfile(
            Consumer<GetServiceProfileRequest.Builder> getServiceProfileRequest) {
        return getServiceProfile(GetServiceProfileRequest.builder().applyMutation(getServiceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceRequest
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(GetWirelessDeviceRequest getWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceResponse> getWirelessDevice(
            Consumer<GetWirelessDeviceRequest.Builder> getWirelessDeviceRequest) {
        return getWirelessDevice(GetWirelessDeviceRequest.builder().applyMutation(getWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            GetWirelessDeviceStatisticsRequest getWirelessDeviceStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessDeviceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessDeviceStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessDeviceStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessDeviceStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetWirelessDeviceStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessDeviceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessDeviceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessDeviceStatisticsResponse> getWirelessDeviceStatistics(
            Consumer<GetWirelessDeviceStatisticsRequest.Builder> getWirelessDeviceStatisticsRequest) {
        return getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.builder()
                .applyMutation(getWirelessDeviceStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayRequest
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(GetWirelessGatewayRequest getWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayResponse> getWirelessGateway(
            Consumer<GetWirelessGatewayRequest.Builder> getWirelessGatewayRequest) {
        return getWirelessGateway(GetWirelessGatewayRequest.builder().applyMutation(getWirelessGatewayRequest).build());
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            GetWirelessGatewayCertificateRequest getWirelessGatewayCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayCertificateRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayCertificateResponse> getWirelessGatewayCertificate(
            Consumer<GetWirelessGatewayCertificateRequest.Builder> getWirelessGatewayCertificateRequest) {
        return getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.builder()
                .applyMutation(getWirelessGatewayCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            GetWirelessGatewayFirmwareInformationRequest getWirelessGatewayFirmwareInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the firmware version and other information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetWirelessGatewayFirmwareInformationRequest.Builder} avoiding the need to create one manually via
     * {@link GetWirelessGatewayFirmwareInformationRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayFirmwareInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayFirmwareInformationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayFirmwareInformation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayFirmwareInformation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayFirmwareInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayFirmwareInformationResponse> getWirelessGatewayFirmwareInformation(
            Consumer<GetWirelessGatewayFirmwareInformationRequest.Builder> getWirelessGatewayFirmwareInformationRequest) {
        return getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.builder()
                .applyMutation(getWirelessGatewayFirmwareInformationRequest).build());
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            GetWirelessGatewayStatisticsRequest getWirelessGatewayStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operating information about a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayStatisticsRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetWirelessGatewayStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayStatisticsResponse> getWirelessGatewayStatistics(
            Consumer<GetWirelessGatewayStatisticsRequest.Builder> getWirelessGatewayStatisticsRequest) {
        return getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.builder()
                .applyMutation(getWirelessGatewayStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            GetWirelessGatewayTaskRequest getWirelessGatewayTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetWirelessGatewayTaskRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWirelessGatewayTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskResponse> getWirelessGatewayTask(
            Consumer<GetWirelessGatewayTaskRequest.Builder> getWirelessGatewayTaskRequest) {
        return getWirelessGatewayTask(GetWirelessGatewayTaskRequest.builder().applyMutation(getWirelessGatewayTaskRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            GetWirelessGatewayTaskDefinitionRequest getWirelessGatewayTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a wireless gateway task definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWirelessGatewayTaskDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetWirelessGatewayTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param getWirelessGatewayTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetWirelessGatewayTaskDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWirelessGatewayTaskDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.GetWirelessGatewayTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/GetWirelessGatewayTaskDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWirelessGatewayTaskDefinitionResponse> getWirelessGatewayTaskDefinition(
            Consumer<GetWirelessGatewayTaskDefinitionRequest.Builder> getWirelessGatewayTaskDefinitionRequest) {
        return getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.builder()
                .applyMutation(getWirelessGatewayTaskDefinitionRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(
            Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the destinations registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDestinationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDestinations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeviceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceProfilesResponse> listDeviceProfiles(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) {
        return listDeviceProfiles(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesPublisher listDeviceProfilesPaginator(ListDeviceProfilesRequest listDeviceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListDeviceProfilesPublisher publisher = client.listDeviceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceProfiles(software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceProfilesRequest#builder()}
     * </p>
     *
     * @param listDeviceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListDeviceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListDeviceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceProfilesPublisher listDeviceProfilesPaginator(
            Consumer<ListDeviceProfilesRequest.Builder> listDeviceProfilesRequest) {
        return listDeviceProfilesPaginator(ListDeviceProfilesRequest.builder().applyMutation(listDeviceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     *
     * @param listPartnerAccountsRequest
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            ListPartnerAccountsRequest listPartnerAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partner accounts associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPartnerAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerAccountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPartnerAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListPartnerAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListPartnerAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerAccountsResponse> listPartnerAccounts(
            Consumer<ListPartnerAccountsRequest.Builder> listPartnerAccountsRequest) {
        return listPartnerAccounts(ListPartnerAccountsRequest.builder().applyMutation(listPartnerAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            ListServiceProfilesRequest listServiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceProfilesResponse> listServiceProfiles(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) {
        return listServiceProfiles(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesPublisher listServiceProfilesPaginator(ListServiceProfilesRequest listServiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service profiles registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListServiceProfilesPublisher publisher = client.listServiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceProfiles(software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceProfilesRequest#builder()}
     * </p>
     *
     * @param listServiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListServiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListServiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceProfilesPublisher listServiceProfilesPaginator(
            Consumer<ListServiceProfilesRequest.Builder> listServiceProfilesRequest) {
        return listServiceProfilesPaginator(ListServiceProfilesRequest.builder().applyMutation(listServiceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            ListWirelessDevicesRequest listWirelessDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWirelessDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessDevicesResponse> listWirelessDevices(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) {
        return listWirelessDevices(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesPublisher listWirelessDevicesPaginator(ListWirelessDevicesRequest listWirelessDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless devices registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessDevicesPublisher publisher = client.listWirelessDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessDevices(software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessDevicesRequest#builder()}
     * </p>
     *
     * @param listWirelessDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessDevicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessDevicesPublisher listWirelessDevicesPaginator(
            Consumer<ListWirelessDevicesRequest.Builder> listWirelessDevicesRequest) {
        return listWirelessDevicesPaginator(ListWirelessDevicesRequest.builder().applyMutation(listWirelessDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            ListWirelessGatewayTaskDefinitionsRequest listWirelessGatewayTaskDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the wireless gateway tasks definitions registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewayTaskDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWirelessGatewayTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewayTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewayTaskDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWirelessGatewayTaskDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGatewayTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewayTaskDefinitionsResponse> listWirelessGatewayTaskDefinitions(
            Consumer<ListWirelessGatewayTaskDefinitionsRequest.Builder> listWirelessGatewayTaskDefinitionsRequest) {
        return listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.builder()
                .applyMutation(listWirelessGatewayTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWirelessGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWirelessGatewaysResponse> listWirelessGateways(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) {
        return listWirelessGateways(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWirelessGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysPublisher listWirelessGatewaysPaginator(ListWirelessGatewaysRequest listWirelessGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the wireless gateways registered to your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotwireless.paginators.ListWirelessGatewaysPublisher publisher = client.listWirelessGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWirelessGateways(software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWirelessGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListWirelessGatewaysRequest#builder()}
     * </p>
     *
     * @param listWirelessGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListWirelessGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.ListWirelessGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWirelessGatewaysPublisher listWirelessGatewaysPaginator(
            Consumer<ListWirelessGatewaysRequest.Builder> listWirelessGatewaysRequest) {
        return listWirelessGatewaysPaginator(ListWirelessGatewaysRequest.builder().applyMutation(listWirelessGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            SendDataToWirelessDeviceRequest sendDataToWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a decrypted application data frame to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendDataToWirelessDeviceRequest.Builder} avoiding
     * the need to create one manually via {@link SendDataToWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param sendDataToWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link SendDataToWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendDataToWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.SendDataToWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SendDataToWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDataToWirelessDeviceResponse> sendDataToWirelessDevice(
            Consumer<SendDataToWirelessDeviceRequest.Builder> sendDataToWirelessDeviceRequest) {
        return sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.builder().applyMutation(sendDataToWirelessDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>TooManyTagsException The request was denied because the resource can't have any more tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     *
     * @param testWirelessDeviceRequest
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(TestWirelessDeviceRequest testWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TestWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param testWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link TestWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.TestWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/TestWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestWirelessDeviceResponse> testWirelessDevice(
            Consumer<TestWirelessDeviceRequest.Builder> testWirelessDeviceRequest) {
        return testWirelessDevice(TestWirelessDeviceRequest.builder().applyMutation(testWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>ConflictException Adding, updating, or deleting the resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(
            Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     *
     * @param updatePartnerAccountRequest
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            UpdatePartnerAccountRequest updatePartnerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a partner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnerAccountRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePartnerAccountRequest#builder()}
     * </p>
     *
     * @param updatePartnerAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePartnerAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePartnerAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdatePartnerAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdatePartnerAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePartnerAccountResponse> updatePartnerAccount(
            Consumer<UpdatePartnerAccountRequest.Builder> updatePartnerAccountRequest) {
        return updatePartnerAccount(UpdatePartnerAccountRequest.builder().applyMutation(updatePartnerAccountRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     *
     * @param updateWirelessDeviceRequest
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            UpdateWirelessDeviceRequest updateWirelessDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessDeviceRequest#builder()}
     * </p>
     *
     * @param updateWirelessDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWirelessDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessDeviceResponse> updateWirelessDevice(
            Consumer<UpdateWirelessDeviceRequest.Builder> updateWirelessDeviceRequest) {
        return updateWirelessDevice(UpdateWirelessDeviceRequest.builder().applyMutation(updateWirelessDeviceRequest).build());
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     *
     * @param updateWirelessGatewayRequest
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            UpdateWirelessGatewayRequest updateWirelessGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a wireless gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWirelessGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWirelessGatewayRequest#builder()}
     * </p>
     *
     * @param updateWirelessGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWirelessGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWirelessGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input did not meet the specified constraints.</li>
     *         <li>ResourceNotFoundException Resource does not exist.</li>
     *         <li>AccessDeniedException User does not have permission to perform this action.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ThrottlingException The request was denied because it exceeded the allowed API request rate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotWirelessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotWirelessAsyncClient.UpdateWirelessGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/UpdateWirelessGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWirelessGatewayResponse> updateWirelessGateway(
            Consumer<UpdateWirelessGatewayRequest.Builder> updateWirelessGatewayRequest) {
        return updateWirelessGateway(UpdateWirelessGatewayRequest.builder().applyMutation(updateWirelessGatewayRequest).build());
    }
}
