/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorRequest extends IotEventsDataRequest implements
        ToCopyableBuilder<DescribeDetectorRequest.Builder, DescribeDetectorRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(DescribeDetectorRequest::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(DescribeDetectorRequest::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("keyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            KEY_VALUE_FIELD));

    private final String detectorModelName;

    private final String keyValue;

    private DescribeDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
    }

    /**
     * <p>
     * The name of the detector model whose detectors (instances) you want information about.
     * </p>
     * 
     * @return The name of the detector model whose detectors (instances) you want information about.
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * A filter used to limit results to detectors (instances) created because of the given key ID.
     * </p>
     * 
     * @return A filter used to limit results to detectors (instances) created because of the given key ID.
     */
    public final String keyValue() {
        return keyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorRequest)) {
            return false;
        }
        DescribeDetectorRequest other = (DescribeDetectorRequest) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName()) && Objects.equals(keyValue(), other.keyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectorRequest").add("DetectorModelName", detectorModelName())
                .add("KeyValue", keyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorRequest, T> g) {
        return obj -> g.apply((DescribeDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDetectorRequest> {
        /**
         * <p>
         * The name of the detector model whose detectors (instances) you want information about.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model whose detectors (instances) you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * A filter used to limit results to detectors (instances) created because of the given key ID.
         * </p>
         * 
         * @param keyValue
         *        A filter used to limit results to detectors (instances) created because of the given key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsDataRequest.BuilderImpl implements Builder {
        private String detectorModelName;

        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorRequest model) {
            super(model);
            detectorModelName(model.detectorModelName);
            keyValue(model.keyValue);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDetectorRequest build() {
            return new DescribeDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
