/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.InternalFailureException;
import software.amazon.awssdk.services.ioteventsdata.model.InvalidRequestException;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataException;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ioteventsdata.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ioteventsdata.model.ThrottlingException;

/**
 * Service client for accessing AWS IoT Events Data. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions
 * when such events occur. AWS IoT Events Data API commands enable you to send inputs to detectors, list detectors, and
 * view or update a detector's status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotEventsDataClient extends SdkClient {
    String SERVICE_NAME = "ioteventsdata";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.iotevents";

    /**
     * Create a {@link IotEventsDataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsDataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsDataClient}.
     */
    static IotEventsDataClientBuilder builder() {
        return new DefaultIotEventsDataClientBuilder();
    }

    /**
     * <p>
     * Sends a set of messages to the AWS IoT Events system. Each message payload is transformed into the input you
     * specify (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages
     * are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     *
     * @param batchPutMessageRequest
     * @return Result of the BatchPutMessage operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMessageResponse batchPutMessage(BatchPutMessageRequest batchPutMessageRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a set of messages to the AWS IoT Events system. Each message payload is transformed into the input you
     * specify (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages
     * are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMessageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMessageRequest#builder()}
     * </p>
     *
     * @param batchPutMessageRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutMessageRequest.Builder} to create a request.
     * @return Result of the BatchPutMessage operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMessageResponse batchPutMessage(Consumer<BatchPutMessageRequest.Builder> batchPutMessageRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchPutMessage(BatchPutMessageRequest.builder().applyMutation(batchPutMessageRequest).build());
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     *
     * @param batchUpdateDetectorRequest
     * @return Result of the BatchUpdateDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDetectorResponse batchUpdateDetector(BatchUpdateDetectorRequest batchUpdateDetectorRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateDetectorRequest#builder()}
     * </p>
     *
     * @param batchUpdateDetectorRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateDetectorRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDetectorResponse batchUpdateDetector(
            Consumer<BatchUpdateDetectorRequest.Builder> batchUpdateDetectorRequest) throws InvalidRequestException,
            InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotEventsDataException {
        return batchUpdateDetector(BatchUpdateDetectorRequest.builder().applyMutation(batchUpdateDetectorRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     *
     * @param describeDetectorRequest
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorRequest.Builder} to create a request.
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     *
     * @param listDetectorsRequest
     * @return Result of the ListDetectors operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorsRequest.Builder} to create a request.
     * @return Result of the ListDetectors operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occured.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorsResponse listDetectors(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        return listDetectors(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
