/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.AnalysisResult;
import software.amazon.awssdk.services.iotevents.model.AnalysisResultsCopier;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDetectorModelAnalysisResultsResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, GetDetectorModelAnalysisResultsResponse> {
    private static final SdkField<List<AnalysisResult>> ANALYSIS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisResults").getter(GetDetectorModelAnalysisResultsResponse.getter(GetDetectorModelAnalysisResultsResponse::analysisResults)).setter(GetDetectorModelAnalysisResultsResponse.setter(Builder::analysisResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDetectorModelAnalysisResultsResponse.getter(GetDetectorModelAnalysisResultsResponse::nextToken)).setter(GetDetectorModelAnalysisResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnalysisResult> analysisResults;
    private final String nextToken;

    private GetDetectorModelAnalysisResultsResponse(BuilderImpl builder) {
        super(builder);
        this.analysisResults = builder.analysisResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnalysisResults() {
        return this.analysisResults != null && !(this.analysisResults instanceof SdkAutoConstructList);
    }

    public final List<AnalysisResult> analysisResults() {
        return this.analysisResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisResults() ? this.analysisResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorModelAnalysisResultsResponse)) {
            return false;
        }
        GetDetectorModelAnalysisResultsResponse other = (GetDetectorModelAnalysisResultsResponse)((Object)obj);
        return this.hasAnalysisResults() == other.hasAnalysisResults() && Objects.equals(this.analysisResults(), other.analysisResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDetectorModelAnalysisResultsResponse").add("AnalysisResults", this.hasAnalysisResults() ? this.analysisResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisResults": {
                return Optional.ofNullable(clazz.cast(this.analysisResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorModelAnalysisResultsResponse, T> g) {
        return obj -> g.apply((GetDetectorModelAnalysisResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private List<AnalysisResult> analysisResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorModelAnalysisResultsResponse model) {
            super(model);
            this.analysisResults(model.analysisResults);
            this.nextToken(model.nextToken);
        }

        public final List<AnalysisResult.Builder> getAnalysisResults() {
            List<AnalysisResult.Builder> result = AnalysisResultsCopier.copyToBuilder(this.analysisResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder analysisResults(Collection<AnalysisResult> analysisResults) {
            this.analysisResults = AnalysisResultsCopier.copy(analysisResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisResults(AnalysisResult ... analysisResults) {
            this.analysisResults(Arrays.asList(analysisResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisResults(Consumer<AnalysisResult.Builder> ... analysisResults) {
            this.analysisResults(Stream.of(analysisResults).map(c -> (AnalysisResult)((AnalysisResult.Builder)AnalysisResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnalysisResults(Collection<AnalysisResult.BuilderImpl> analysisResults) {
            this.analysisResults = AnalysisResultsCopier.copyFromBuilder(analysisResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDetectorModelAnalysisResultsResponse build() {
            return new GetDetectorModelAnalysisResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDetectorModelAnalysisResultsResponse> {
        public Builder analysisResults(Collection<AnalysisResult> var1);

        public Builder analysisResults(AnalysisResult ... var1);

        public Builder analysisResults(Consumer<AnalysisResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

