/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.TopicRuleListItem;

public class ListTopicRulesPublisher
implements SdkPublisher<ListTopicRulesResponse> {
    private final IotAsyncClient client;
    private final ListTopicRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTopicRulesPublisher(IotAsyncClient client, ListTopicRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTopicRulesPublisher(IotAsyncClient client, ListTopicRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTopicRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTopicRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicRuleListItem> rules() {
        Function<ListTopicRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTopicRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTopicRulesResponseFetcher
    implements AsyncPageFetcher<ListTopicRulesResponse> {
        private ListTopicRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTopicRulesResponse> nextPage(ListTopicRulesResponse previousPage) {
            if (previousPage == null) {
                return ListTopicRulesPublisher.this.client.listTopicRules(ListTopicRulesPublisher.this.firstRequest);
            }
            return ListTopicRulesPublisher.this.client.listTopicRules((ListTopicRulesRequest)((Object)ListTopicRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

