/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;

public class ListAuditMitigationActionsTasksPublisher
implements SdkPublisher<ListAuditMitigationActionsTasksResponse> {
    private final IotAsyncClient client;
    private final ListAuditMitigationActionsTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuditMitigationActionsTasksPublisher(IotAsyncClient client, ListAuditMitigationActionsTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuditMitigationActionsTasksPublisher(IotAsyncClient client, ListAuditMitigationActionsTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuditMitigationActionsTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuditMitigationActionsTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuditMitigationActionsTaskMetadata> tasks() {
        Function<ListAuditMitigationActionsTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuditMitigationActionsTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuditMitigationActionsTasksResponseFetcher
    implements AsyncPageFetcher<ListAuditMitigationActionsTasksResponse> {
        private ListAuditMitigationActionsTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditMitigationActionsTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuditMitigationActionsTasksResponse> nextPage(ListAuditMitigationActionsTasksResponse previousPage) {
            if (previousPage == null) {
                return ListAuditMitigationActionsTasksPublisher.this.client.listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksPublisher.this.firstRequest);
            }
            return ListAuditMitigationActionsTasksPublisher.this.client.listAuditMitigationActionsTasks((ListAuditMitigationActionsTasksRequest)((Object)ListAuditMitigationActionsTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

