/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRuleDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestination.getter(TopicRuleDestination::arn)).setter(TopicRuleDestination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestination.getter(TopicRuleDestination::statusAsString)).setter(TopicRuleDestination.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRuleDestination.getter(TopicRuleDestination::statusReason)).setter(TopicRuleDestination.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<HttpUrlDestinationProperties> HTTP_URL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TopicRuleDestination.getter(TopicRuleDestination::httpUrlProperties)).setter(TopicRuleDestination.setter(Builder::httpUrlProperties)).constructor(HttpUrlDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, HTTP_URL_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final String statusReason;
    private final HttpUrlDestinationProperties httpUrlProperties;

    private TopicRuleDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.httpUrlProperties = builder.httpUrlProperties;
    }

    public String arn() {
        return this.arn;
    }

    public TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public HttpUrlDestinationProperties httpUrlProperties() {
        return this.httpUrlProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpUrlProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestination)) {
            return false;
        }
        TopicRuleDestination other = (TopicRuleDestination)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.httpUrlProperties(), other.httpUrlProperties());
    }

    public String toString() {
        return ToString.builder((String)"TopicRuleDestination").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("HttpUrlProperties", (Object)this.httpUrlProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "httpUrlProperties": {
                return Optional.ofNullable(clazz.cast(this.httpUrlProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestination, T> g) {
        return obj -> g.apply((TopicRuleDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private String statusReason;
        private HttpUrlDestinationProperties httpUrlProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestination model) {
            this.arn(model.arn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.httpUrlProperties(model.httpUrlProperties);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final HttpUrlDestinationProperties.Builder getHttpUrlProperties() {
            return this.httpUrlProperties != null ? this.httpUrlProperties.toBuilder() : null;
        }

        @Override
        public final Builder httpUrlProperties(HttpUrlDestinationProperties httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties;
            return this;
        }

        public final void setHttpUrlProperties(HttpUrlDestinationProperties.BuilderImpl httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties != null ? httpUrlProperties.build() : null;
        }

        public TopicRuleDestination build() {
            return new TopicRuleDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRuleDestination> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(TopicRuleDestinationStatus var1);

        public Builder statusReason(String var1);

        public Builder httpUrlProperties(HttpUrlDestinationProperties var1);

        default public Builder httpUrlProperties(Consumer<HttpUrlDestinationProperties.Builder> httpUrlProperties) {
            return this.httpUrlProperties((HttpUrlDestinationProperties)((HttpUrlDestinationProperties.Builder)HttpUrlDestinationProperties.builder().applyMutation(httpUrlProperties)).build());
        }
    }
}

