/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ResourceArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, RegisterThingResponse> {
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterThingResponse.getter(RegisterThingResponse::certificatePem)).setter(RegisterThingResponse.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(RegisterThingResponse.getter(RegisterThingResponse::resourceArns)).setter(RegisterThingResponse.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PEM_FIELD, RESOURCE_ARNS_FIELD));
    private final String certificatePem;
    private final Map<String, String> resourceArns;

    private RegisterThingResponse(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.resourceArns = builder.resourceArns;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructMap);
    }

    public Map<String, String> resourceArns() {
        return this.resourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterThingResponse)) {
            return false;
        }
        RegisterThingResponse other = (RegisterThingResponse)((Object)obj);
        return Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.resourceArns(), other.resourceArns());
    }

    public String toString() {
        return ToString.builder((String)"RegisterThingResponse").add("CertificatePem", (Object)this.certificatePem()).add("ResourceArns", this.resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterThingResponse, T> g) {
        return obj -> g.apply((RegisterThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificatePem;
        private Map<String, String> resourceArns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterThingResponse model) {
            super(model);
            this.certificatePem(model.certificatePem);
            this.resourceArns(model.resourceArns);
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final Map<String, String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        public final void setResourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public RegisterThingResponse build() {
            return new RegisterThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterThingResponse> {
        public Builder certificatePem(String var1);

        public Builder resourceArns(Map<String, String> var1);
    }
}

