/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingsInThingGroupResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingsInThingGroupResponse> {
    private static final SdkField<List<String>> THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListThingsInThingGroupResponse.getter(ListThingsInThingGroupResponse::things)).setter(ListThingsInThingGroupResponse.setter(Builder::things)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListThingsInThingGroupResponse.getter(ListThingsInThingGroupResponse::nextToken)).setter(ListThingsInThingGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> things;
    private final String nextToken;

    private ListThingsInThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public boolean hasThings() {
        return this.things != null && !(this.things instanceof SdkAutoConstructList);
    }

    public List<String> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.things());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsInThingGroupResponse)) {
            return false;
        }
        ListThingsInThingGroupResponse other = (ListThingsInThingGroupResponse)((Object)obj);
        return Objects.equals(this.things(), other.things()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListThingsInThingGroupResponse").add("Things", this.things()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "things": {
                return Optional.ofNullable(clazz.cast(this.things()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingsInThingGroupResponse, T> g) {
        return obj -> g.apply((ListThingsInThingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> things = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsInThingGroupResponse model) {
            super(model);
            this.things(model.things);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getThings() {
            return this.things;
        }

        @Override
        public final Builder things(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(String ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        public final void setThings(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingsInThingGroupResponse build() {
            return new ListThingsInThingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingsInThingGroupResponse> {
        public Builder things(Collection<String> var1);

        public Builder things(String ... var1);

        public Builder nextToken(String var1);
    }
}

