/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingTypeMetadata;
import software.amazon.awssdk.services.iot.model.ThingTypeProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThingTypeResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeThingTypeResponse> {
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingTypeResponse.getter(DescribeThingTypeResponse::thingTypeName)).setter(DescribeThingTypeResponse.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<String> THING_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingTypeResponse.getter(DescribeThingTypeResponse::thingTypeId)).setter(DescribeThingTypeResponse.setter(Builder::thingTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeId").build()}).build();
    private static final SdkField<String> THING_TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeThingTypeResponse.getter(DescribeThingTypeResponse::thingTypeArn)).setter(DescribeThingTypeResponse.setter(Builder::thingTypeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeArn").build()}).build();
    private static final SdkField<ThingTypeProperties> THING_TYPE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeThingTypeResponse.getter(DescribeThingTypeResponse::thingTypeProperties)).setter(DescribeThingTypeResponse.setter(Builder::thingTypeProperties)).constructor(ThingTypeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeProperties").build()}).build();
    private static final SdkField<ThingTypeMetadata> THING_TYPE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeThingTypeResponse.getter(DescribeThingTypeResponse::thingTypeMetadata)).setter(DescribeThingTypeResponse.setter(Builder::thingTypeMetadata)).constructor(ThingTypeMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_NAME_FIELD, THING_TYPE_ID_FIELD, THING_TYPE_ARN_FIELD, THING_TYPE_PROPERTIES_FIELD, THING_TYPE_METADATA_FIELD));
    private final String thingTypeName;
    private final String thingTypeId;
    private final String thingTypeArn;
    private final ThingTypeProperties thingTypeProperties;
    private final ThingTypeMetadata thingTypeMetadata;

    private DescribeThingTypeResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeId = builder.thingTypeId;
        this.thingTypeArn = builder.thingTypeArn;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.thingTypeMetadata = builder.thingTypeMetadata;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public String thingTypeId() {
        return this.thingTypeId;
    }

    public String thingTypeArn() {
        return this.thingTypeArn;
    }

    public ThingTypeProperties thingTypeProperties() {
        return this.thingTypeProperties;
    }

    public ThingTypeMetadata thingTypeMetadata() {
        return this.thingTypeMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingTypeResponse)) {
            return false;
        }
        DescribeThingTypeResponse other = (DescribeThingTypeResponse)((Object)obj);
        return Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.thingTypeId(), other.thingTypeId()) && Objects.equals(this.thingTypeArn(), other.thingTypeArn()) && Objects.equals(this.thingTypeProperties(), other.thingTypeProperties()) && Objects.equals(this.thingTypeMetadata(), other.thingTypeMetadata());
    }

    public String toString() {
        return ToString.builder((String)"DescribeThingTypeResponse").add("ThingTypeName", (Object)this.thingTypeName()).add("ThingTypeId", (Object)this.thingTypeId()).add("ThingTypeArn", (Object)this.thingTypeArn()).add("ThingTypeProperties", (Object)this.thingTypeProperties()).add("ThingTypeMetadata", (Object)this.thingTypeMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "thingTypeId": {
                return Optional.ofNullable(clazz.cast(this.thingTypeId()));
            }
            case "thingTypeArn": {
                return Optional.ofNullable(clazz.cast(this.thingTypeArn()));
            }
            case "thingTypeProperties": {
                return Optional.ofNullable(clazz.cast(this.thingTypeProperties()));
            }
            case "thingTypeMetadata": {
                return Optional.ofNullable(clazz.cast(this.thingTypeMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingTypeResponse, T> g) {
        return obj -> g.apply((DescribeThingTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String thingTypeName;
        private String thingTypeId;
        private String thingTypeArn;
        private ThingTypeProperties thingTypeProperties;
        private ThingTypeMetadata thingTypeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingTypeResponse model) {
            super(model);
            this.thingTypeName(model.thingTypeName);
            this.thingTypeId(model.thingTypeId);
            this.thingTypeArn(model.thingTypeArn);
            this.thingTypeProperties(model.thingTypeProperties);
            this.thingTypeMetadata(model.thingTypeMetadata);
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final String getThingTypeId() {
            return this.thingTypeId;
        }

        @Override
        public final Builder thingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
            return this;
        }

        public final void setThingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
        }

        public final String getThingTypeArn() {
            return this.thingTypeArn;
        }

        @Override
        public final Builder thingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
            return this;
        }

        public final void setThingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return this.thingTypeProperties != null ? this.thingTypeProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        public final ThingTypeMetadata.Builder getThingTypeMetadata() {
            return this.thingTypeMetadata != null ? this.thingTypeMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
            return this;
        }

        public final void setThingTypeMetadata(ThingTypeMetadata.BuilderImpl thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata != null ? thingTypeMetadata.build() : null;
        }

        @Override
        public DescribeThingTypeResponse build() {
            return new DescribeThingTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeThingTypeResponse> {
        public Builder thingTypeName(String var1);

        public Builder thingTypeId(String var1);

        public Builder thingTypeArn(String var1);

        public Builder thingTypeProperties(ThingTypeProperties var1);

        default public Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return this.thingTypeProperties((ThingTypeProperties)((ThingTypeProperties.Builder)ThingTypeProperties.builder().applyMutation(thingTypeProperties)).build());
        }

        public Builder thingTypeMetadata(ThingTypeMetadata var1);

        default public Builder thingTypeMetadata(Consumer<ThingTypeMetadata.Builder> thingTypeMetadata) {
            return this.thingTypeMetadata((ThingTypeMetadata)((ThingTypeMetadata.Builder)ThingTypeMetadata.builder().applyMutation(thingTypeMetadata)).build());
        }
    }
}

