/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConfigCapabilityType {
    ANTENNA_DOWNLINK("antenna-downlink"),
    ANTENNA_DOWNLINK_DEMOD_DECODE("antenna-downlink-demod-decode"),
    ANTENNA_UPLINK("antenna-uplink"),
    DATAFLOW_ENDPOINT("dataflow-endpoint"),
    TRACKING("tracking"),
    UPLINK_ECHO("uplink-echo"),
    S3_RECORDING("s3-recording"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConfigCapabilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigCapabilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConfigCapabilityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigCapabilityType> knownValues() {
        return Stream.of(ConfigCapabilityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

