/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionDefinitionVersionResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetFunctionDefinitionVersionResponse.Builder, GetFunctionDefinitionVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetFunctionDefinitionVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTimestamp").getter(getter(GetFunctionDefinitionVersionResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<FunctionDefinitionVersion> DEFINITION_FIELD = SdkField
            .<FunctionDefinitionVersion> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(GetFunctionDefinitionVersionResponse::definition)).setter(setter(Builder::definition))
            .constructor(FunctionDefinitionVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetFunctionDefinitionVersionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFunctionDefinitionVersionResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(GetFunctionDefinitionVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, DEFINITION_FIELD, ID_FIELD, NEXT_TOKEN_FIELD, VERSION_FIELD));

    private final String arn;

    private final String creationTimestamp;

    private final FunctionDefinitionVersion definition;

    private final String id;

    private final String nextToken;

    private final String version;

    private GetFunctionDefinitionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.definition = builder.definition;
        this.id = builder.id;
        this.nextToken = builder.nextToken;
        this.version = builder.version;
    }

    /**
     * The ARN of the function definition version.
     * 
     * @return The ARN of the function definition version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The time, in milliseconds since the epoch, when the function definition version was created.
     * 
     * @return The time, in milliseconds since the epoch, when the function definition version was created.
     */
    public final String creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * Information on the definition.
     * 
     * @return Information on the definition.
     */
    public final FunctionDefinitionVersion definition() {
        return definition;
    }

    /**
     * The ID of the function definition version.
     * 
     * @return The ID of the function definition version.
     */
    public final String id() {
        return id;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The version of the function definition version.
     * 
     * @return The version of the function definition version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionDefinitionVersionResponse)) {
            return false;
        }
        GetFunctionDefinitionVersionResponse other = (GetFunctionDefinitionVersionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(definition(), other.definition()) && Objects.equals(id(), other.id())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionDefinitionVersionResponse").add("Arn", arn())
                .add("CreationTimestamp", creationTimestamp()).add("Definition", definition()).add("Id", id())
                .add("NextToken", nextToken()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionDefinitionVersionResponse, T> g) {
        return obj -> g.apply((GetFunctionDefinitionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFunctionDefinitionVersionResponse> {
        /**
         * The ARN of the function definition version.
         * 
         * @param arn
         *        The ARN of the function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time, in milliseconds since the epoch, when the function definition version was created.
         * 
         * @param creationTimestamp
         *        The time, in milliseconds since the epoch, when the function definition version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(String creationTimestamp);

        /**
         * Information on the definition.
         * 
         * @param definition
         *        Information on the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(FunctionDefinitionVersion definition);

        /**
         * Information on the definition. This is a convenience that creates an instance of the
         * {@link FunctionDefinitionVersion.Builder} avoiding the need to create one manually via
         * {@link FunctionDefinitionVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionDefinitionVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(FunctionDefinitionVersion)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link FunctionDefinitionVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(FunctionDefinitionVersion)
         */
        default Builder definition(Consumer<FunctionDefinitionVersion.Builder> definition) {
            return definition(FunctionDefinitionVersion.builder().applyMutation(definition).build());
        }

        /**
         * The ID of the function definition version.
         * 
         * @param id
         *        The ID of the function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The version of the function definition version.
         * 
         * @param version
         *        The version of the function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationTimestamp;

        private FunctionDefinitionVersion definition;

        private String id;

        private String nextToken;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionDefinitionVersionResponse model) {
            super(model);
            arn(model.arn);
            creationTimestamp(model.creationTimestamp);
            definition(model.definition);
            id(model.id);
            nextToken(model.nextToken);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final FunctionDefinitionVersion.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(FunctionDefinitionVersion definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(FunctionDefinitionVersion.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public GetFunctionDefinitionVersionResponse build() {
            return new GetFunctionDefinitionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
