/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A classifier for <code>XML</code> content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class XMLClassifier implements SdkPojo, Serializable, ToCopyableBuilder<XMLClassifier.Builder, XMLClassifier> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(XMLClassifier::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(XMLClassifier::classification)).setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(XMLClassifier::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(XMLClassifier::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(XMLClassifier::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> ROW_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RowTag")
            .getter(getter(XMLClassifier::rowTag)).setter(setter(Builder::rowTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLASSIFICATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, VERSION_FIELD, ROW_TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String classification;

    private final Instant creationTime;

    private final Instant lastUpdated;

    private final Long version;

    private final String rowTag;

    private XMLClassifier(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.version = builder.version;
        this.rowTag = builder.rowTag;
    }

    /**
     * <p>
     * The name of the classifier.
     * </p>
     * 
     * @return The name of the classifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An identifier of the data format that the classifier matches.
     * </p>
     * 
     * @return An identifier of the data format that the classifier matches.
     */
    public final String classification() {
        return classification;
    }

    /**
     * <p>
     * The time that this classifier was registered.
     * </p>
     * 
     * @return The time that this classifier was registered.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that this classifier was last updated.
     * </p>
     * 
     * @return The time that this classifier was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The version of this classifier.
     * </p>
     * 
     * @return The version of this classifier.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The XML tag designating the element that contains each record in an XML document being parsed. This can't
     * identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
     * attributes can be parsed as long as it ends with a closing tag (for example,
     * <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
     * <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
     * </p>
     * 
     * @return The XML tag designating the element that contains each record in an XML document being parsed. This can't
     *         identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
     *         attributes can be parsed as long as it ends with a closing tag (for example,
     *         <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
     *         <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
     */
    public final String rowTag() {
        return rowTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(rowTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XMLClassifier)) {
            return false;
        }
        XMLClassifier other = (XMLClassifier) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(classification(), other.classification())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(version(), other.version()) && Objects.equals(rowTag(), other.rowTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("XMLClassifier").add("Name", name()).add("Classification", classification())
                .add("CreationTime", creationTime()).add("LastUpdated", lastUpdated()).add("Version", version())
                .add("RowTag", rowTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "RowTag":
            return Optional.ofNullable(clazz.cast(rowTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XMLClassifier, T> g) {
        return obj -> g.apply((XMLClassifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XMLClassifier> {
        /**
         * <p>
         * The name of the classifier.
         * </p>
         * 
         * @param name
         *        The name of the classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An identifier of the data format that the classifier matches.
         * </p>
         * 
         * @param classification
         *        An identifier of the data format that the classifier matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The time that this classifier was registered.
         * </p>
         * 
         * @param creationTime
         *        The time that this classifier was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that this classifier was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time that this classifier was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The version of this classifier.
         * </p>
         * 
         * @param version
         *        The version of this classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The XML tag designating the element that contains each record in an XML document being parsed. This can't
         * identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
         * attributes can be parsed as long as it ends with a closing tag (for example,
         * <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
         * <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
         * </p>
         * 
         * @param rowTag
         *        The XML tag designating the element that contains each record in an XML document being parsed. This
         *        can't identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that
         *        contains only attributes can be parsed as long as it ends with a closing tag (for example,
         *        <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
         *        <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowTag(String rowTag);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String classification;

        private Instant creationTime;

        private Instant lastUpdated;

        private Long version;

        private String rowTag;

        private BuilderImpl() {
        }

        private BuilderImpl(XMLClassifier model) {
            name(model.name);
            classification(model.classification);
            creationTime(model.creationTime);
            lastUpdated(model.lastUpdated);
            version(model.version);
            rowTag(model.rowTag);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClassification() {
            return classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getRowTag() {
            return rowTag;
        }

        @Override
        public final Builder rowTag(String rowTag) {
            this.rowTag = rowTag;
            return this;
        }

        public final void setRowTag(String rowTag) {
            this.rowTag = rowTag;
        }

        @Override
        public XMLClassifier build() {
            return new XMLClassifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
