/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing metadata information for a schema version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataInfo implements SdkPojo, Serializable, ToCopyableBuilder<MetadataInfo.Builder, MetadataInfo> {
    private static final SdkField<String> METADATA_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataValue").getter(getter(MetadataInfo::metadataValue)).setter(setter(Builder::metadataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataValue").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(MetadataInfo::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<OtherMetadataValueListItem>> OTHER_METADATA_VALUE_LIST_FIELD = SdkField
            .<List<OtherMetadataValueListItem>> builder(MarshallingType.LIST)
            .memberName("OtherMetadataValueList")
            .getter(getter(MetadataInfo::otherMetadataValueList))
            .setter(setter(Builder::otherMetadataValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherMetadataValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OtherMetadataValueListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(OtherMetadataValueListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_VALUE_FIELD,
            CREATED_TIME_FIELD, OTHER_METADATA_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metadataValue;

    private final String createdTime;

    private final List<OtherMetadataValueListItem> otherMetadataValueList;

    private MetadataInfo(BuilderImpl builder) {
        this.metadataValue = builder.metadataValue;
        this.createdTime = builder.createdTime;
        this.otherMetadataValueList = builder.otherMetadataValueList;
    }

    /**
     * <p>
     * The metadata key’s corresponding value.
     * </p>
     * 
     * @return The metadata key’s corresponding value.
     */
    public final String metadataValue() {
        return metadataValue;
    }

    /**
     * <p>
     * The time at which the entry was created.
     * </p>
     * 
     * @return The time at which the entry was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * Returns true if the OtherMetadataValueList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOtherMetadataValueList() {
        return otherMetadataValueList != null && !(otherMetadataValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Other metadata belonging to the same metadata key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOtherMetadataValueList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Other metadata belonging to the same metadata key.
     */
    public final List<OtherMetadataValueListItem> otherMetadataValueList() {
        return otherMetadataValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataValue());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasOtherMetadataValueList() ? otherMetadataValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataInfo)) {
            return false;
        }
        MetadataInfo other = (MetadataInfo) obj;
        return Objects.equals(metadataValue(), other.metadataValue()) && Objects.equals(createdTime(), other.createdTime())
                && hasOtherMetadataValueList() == other.hasOtherMetadataValueList()
                && Objects.equals(otherMetadataValueList(), other.otherMetadataValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataInfo").add("MetadataValue", metadataValue()).add("CreatedTime", createdTime())
                .add("OtherMetadataValueList", hasOtherMetadataValueList() ? otherMetadataValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataValue":
            return Optional.ofNullable(clazz.cast(metadataValue()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "OtherMetadataValueList":
            return Optional.ofNullable(clazz.cast(otherMetadataValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataInfo, T> g) {
        return obj -> g.apply((MetadataInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataInfo> {
        /**
         * <p>
         * The metadata key’s corresponding value.
         * </p>
         * 
         * @param metadataValue
         *        The metadata key’s corresponding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataValue(String metadataValue);

        /**
         * <p>
         * The time at which the entry was created.
         * </p>
         * 
         * @param createdTime
         *        The time at which the entry was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * Other metadata belonging to the same metadata key.
         * </p>
         * 
         * @param otherMetadataValueList
         *        Other metadata belonging to the same metadata key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherMetadataValueList(Collection<OtherMetadataValueListItem> otherMetadataValueList);

        /**
         * <p>
         * Other metadata belonging to the same metadata key.
         * </p>
         * 
         * @param otherMetadataValueList
         *        Other metadata belonging to the same metadata key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherMetadataValueList(OtherMetadataValueListItem... otherMetadataValueList);

        /**
         * <p>
         * Other metadata belonging to the same metadata key.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OtherMetadataValueListItem>.Builder}
         * avoiding the need to create one manually via {@link List<OtherMetadataValueListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OtherMetadataValueListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #otherMetadataValueList(List<OtherMetadataValueListItem>)}.
         * 
         * @param otherMetadataValueList
         *        a consumer that will call methods on {@link List<OtherMetadataValueListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otherMetadataValueList(List<OtherMetadataValueListItem>)
         */
        Builder otherMetadataValueList(Consumer<OtherMetadataValueListItem.Builder>... otherMetadataValueList);
    }

    static final class BuilderImpl implements Builder {
        private String metadataValue;

        private String createdTime;

        private List<OtherMetadataValueListItem> otherMetadataValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataInfo model) {
            metadataValue(model.metadataValue);
            createdTime(model.createdTime);
            otherMetadataValueList(model.otherMetadataValueList);
        }

        public final String getMetadataValue() {
            return metadataValue;
        }

        @Override
        public final Builder metadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
            return this;
        }

        public final void setMetadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final List<OtherMetadataValueListItem.Builder> getOtherMetadataValueList() {
            List<OtherMetadataValueListItem.Builder> result = OtherMetadataValueListCopier
                    .copyToBuilder(this.otherMetadataValueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder otherMetadataValueList(Collection<OtherMetadataValueListItem> otherMetadataValueList) {
            this.otherMetadataValueList = OtherMetadataValueListCopier.copy(otherMetadataValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherMetadataValueList(OtherMetadataValueListItem... otherMetadataValueList) {
            otherMetadataValueList(Arrays.asList(otherMetadataValueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherMetadataValueList(Consumer<OtherMetadataValueListItem.Builder>... otherMetadataValueList) {
            otherMetadataValueList(Stream.of(otherMetadataValueList)
                    .map(c -> OtherMetadataValueListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOtherMetadataValueList(Collection<OtherMetadataValueListItem.BuilderImpl> otherMetadataValueList) {
            this.otherMetadataValueList = OtherMetadataValueListCopier.copyFromBuilder(otherMetadataValueList);
        }

        @Override
        public MetadataInfo build() {
            return new MetadataInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
